/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowConditionProviderFactory;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.models.workflow.WorkflowStep;
import org.keycloak.models.workflow.WorkflowStepProvider;
import org.keycloak.models.workflow.WorkflowStepProviderFactory;

public final class Workflows {
    public static WorkflowConditionProvider getConditionProvider(KeycloakSession session, String name, String expression) {
        return Workflows.getConditionProviderFactory(session, name).create(session, expression);
    }

    private static WorkflowConditionProviderFactory<WorkflowConditionProvider> getConditionProviderFactory(KeycloakSession session, String providerId) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        WorkflowConditionProviderFactory providerFactory = (WorkflowConditionProviderFactory)sessionFactory.getProviderFactory(WorkflowConditionProvider.class, providerId);
        if (providerFactory == null) {
            throw new WorkflowInvalidStateException("Could not find condition provider: " + providerId);
        }
        return providerFactory;
    }

    public static WorkflowStepProvider getStepProvider(KeycloakSession session, WorkflowStep step) {
        RealmModel realm = session.getContext().getRealm();
        return (WorkflowStepProvider)Workflows.getStepProviderFactory(session, step).create(session, realm.getComponent(step.getId()));
    }

    private static WorkflowStepProviderFactory<WorkflowStepProvider> getStepProviderFactory(KeycloakSession session, WorkflowStep step) {
        WorkflowStepProviderFactory factory = (WorkflowStepProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(WorkflowStepProvider.class, step.getProviderId());
        if (factory == null) {
            throw new WorkflowInvalidStateException("Step not found: " + step.getProviderId());
        }
        return factory;
    }
}

