/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.error;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.forms.login.MessageType;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTaskWithResult;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.theme.Theme;
import org.keycloak.theme.beans.AdvancedMessageFormatterMethod;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.freemarker.FreeMarkerProvider;
import org.keycloak.utils.KeycloakSessionUtil;
import org.keycloak.utils.MediaType;
import org.keycloak.utils.MediaTypeMatcher;

@Provider
public class KeycloakErrorHandler
implements ExceptionMapper<Throwable> {
    private static final Logger logger = Logger.getLogger(KeycloakErrorHandler.class);
    private static final Pattern realmNamePattern = Pattern.compile(".*/realms/([^/]+).*");
    public static final String UNCAUGHT_SERVER_ERROR_TEXT = "Uncaught server error";
    public static final String ERROR_RESPONSE_TEXT = "Error response {0}";

    public Response toResponse(final Throwable throwable) {
        KeycloakSession session = KeycloakSessionUtil.getKeycloakSession();
        if (session == null) {
            return (Response)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)KeycloakApplication.getSessionFactory(), (KeycloakSessionTaskWithResult)new KeycloakSessionTaskWithResult<Response>(){

                public Response run(KeycloakSession session) {
                    return KeycloakErrorHandler.getResponse(session, throwable);
                }
            });
        }
        return KeycloakErrorHandler.getResponse(session, throwable);
    }

    public static Response getResponse(KeycloakSession session, Throwable throwable) {
        KeycloakTransactionManager tx = session.getTransactionManager();
        tx.setRollbackOnly();
        Response.Status responseStatus = KeycloakErrorHandler.getResponseStatus(throwable);
        boolean isServerError = responseStatus.getFamily().equals((Object)Response.Status.Family.SERVER_ERROR);
        if (isServerError) {
            logger.error((Object)UNCAUGHT_SERVER_ERROR_TEXT, throwable);
        } else {
            logger.debugv(throwable, ERROR_RESPONSE_TEXT, (Object)responseStatus);
        }
        HttpHeaders headers = session.getContext().getRequestHeaders();
        if (!MediaTypeMatcher.isHtmlRequest(headers)) {
            OAuth2ErrorRepresentation error = new OAuth2ErrorRepresentation();
            error.setError(KeycloakErrorHandler.getErrorCode(throwable));
            if (throwable.getCause() instanceof ModelException) {
                error.setErrorDescription(throwable.getMessage());
            }
            if (throwable instanceof ModelDuplicateException) {
                error.setErrorDescription(throwable.getMessage());
            } else if (throwable instanceof JsonProcessingException || throwable.getCause() instanceof JsonProcessingException) {
                error.setErrorDescription("Cannot parse the JSON");
            } else if (isServerError) {
                error.setErrorDescription("For more on this error consult the server log.");
            }
            return Response.status((Response.Status)responseStatus).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build();
        }
        try {
            RealmModel realm = KeycloakErrorHandler.resolveRealm(session);
            Theme theme = session.theme().getTheme(Theme.Type.LOGIN);
            Locale locale = session.getContext().resolveLocale(null);
            FreeMarkerProvider freeMarker = (FreeMarkerProvider)session.getProvider(FreeMarkerProvider.class);
            Map<String, Object> attributes = KeycloakErrorHandler.initAttributes(session, realm, theme, locale, responseStatus);
            String templateName = "error.ftl";
            String content = freeMarker.processTemplate(attributes, templateName, theme);
            return Response.status((Response.Status)responseStatus).type(MediaType.TEXT_HTML_UTF_8_TYPE).entity((Object)content).build();
        }
        catch (Throwable t) {
            logger.error((Object)"Failed to create error page", t);
            return Response.serverError().build();
        }
    }

    private static Response.Status getResponseStatus(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            WebApplicationException ex = (WebApplicationException)throwable;
            return Response.Status.fromStatusCode((int)ex.getResponse().getStatus());
        }
        if (throwable instanceof JsonProcessingException || throwable instanceof ModelValidationException) {
            return Response.Status.BAD_REQUEST;
        }
        if (throwable instanceof ModelIllegalStateException) {
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (throwable instanceof ModelDuplicateException) {
            return Response.Status.CONFLICT;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }

    private static String getErrorCode(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause instanceof JsonParseException) {
            return "invalid_request";
        }
        if (cause instanceof ModelDuplicateException || throwable instanceof ModelDuplicateException) {
            return "conflict";
        }
        if (throwable instanceof WebApplicationException && throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        return "unknown_error";
    }

    private static RealmModel resolveRealm(KeycloakSession session) {
        RealmManager realmManager = new RealmManager(session);
        String path = session.getContext().getUri().getPath();
        Matcher m = realmNamePattern.matcher(path);
        String realmName = m.matches() ? m.group(1) : Config.getAdminRealm();
        RealmModel realm = realmManager.getRealmByName(realmName);
        if (realm == null) {
            realm = realmManager.getRealmByName(Config.getAdminRealm());
        }
        session.getContext().setRealm(realm);
        return realm;
    }

    private static Map<String, Object> initAttributes(KeycloakSession session, RealmModel realm, Theme theme, Locale locale, Response.Status responseStatus) throws IOException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Properties messagesBundle = theme.getEnhancedMessages(realm, locale);
        LocaleBean localeBean = new LocaleBean(realm, locale, session.getContext().getUri().getRequestUriBuilder(), messagesBundle);
        String lang = realm.isInternationalizationEnabled() ? localeBean.getCurrentLanguageTag() : Locale.ENGLISH.toLanguageTag();
        attributes.put("pageId", "error");
        attributes.put("statusCode", responseStatus.getStatusCode());
        attributes.put("realm", realm);
        attributes.put("url", new UrlBean(realm, theme, session.getContext().getUri().getBaseUri(), null));
        attributes.put("locale", localeBean);
        attributes.put("lang", lang);
        String errorKey = responseStatus == Response.Status.NOT_FOUND ? "pageNotFound" : "internalServerError";
        String errorMessage = messagesBundle.getProperty(errorKey);
        attributes.put("message", new MessageBean(errorMessage, MessageType.ERROR));
        attributes.put("darkMode", true);
        attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
        try {
            Properties properties = theme.getProperties();
            attributes.put("properties", properties);
            attributes.put("darkMode", "true".equals(properties.getProperty("darkMode")) && realm.getAttribute("darkMode", Boolean.valueOf(true)) != false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attributes;
    }
}

