/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.async;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.async.AsyncContainer;
import org.infinispan.api.async.AsyncQuery;
import org.infinispan.api.async.AsyncStreamingCache;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;

public interface AsyncCache<K, V> {
    public String name();

    public CompletionStage<CacheConfiguration> configuration();

    public AsyncContainer container();

    default public CompletionStage<V> get(K key) {
        return this.get(key, CacheOptions.DEFAULT);
    }

    default public CompletionStage<V> get(K key, CacheOptions options) {
        return this.getEntry(key, options).thenApply(ce -> ce != null ? ce.value() : null);
    }

    default public CompletionStage<CacheEntry<K, V>> getEntry(K key) {
        return this.getEntry(key, CacheOptions.DEFAULT);
    }

    public CompletionStage<CacheEntry<K, V>> getEntry(K var1, CacheOptions var2);

    default public CompletionStage<CacheEntry<K, V>> putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    public CompletionStage<CacheEntry<K, V>> putIfAbsent(K var1, V var2, CacheWriteOptions var3);

    default public CompletionStage<Boolean> setIfAbsent(K key, V value) {
        return this.setIfAbsent(key, value, CacheWriteOptions.DEFAULT);
    }

    default public CompletionStage<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        return this.putIfAbsent(key, value, options).thenApply(Objects::isNull);
    }

    default public CompletionStage<CacheEntry<K, V>> put(K key, V value) {
        return this.put(key, value, CacheWriteOptions.DEFAULT);
    }

    public CompletionStage<CacheEntry<K, V>> put(K var1, V var2, CacheWriteOptions var3);

    default public CompletionStage<Void> set(K key, V value) {
        return this.set(key, value, CacheWriteOptions.DEFAULT);
    }

    default public CompletionStage<Void> set(K key, V value, CacheWriteOptions options) {
        return this.put(key, value, options).thenApply(__ -> null);
    }

    default public CompletionStage<Boolean> replace(K key, V value, CacheEntryVersion version) {
        return this.replace(key, value, version, CacheWriteOptions.DEFAULT);
    }

    default public CompletionStage<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return this.getOrReplaceEntry(key, value, version, options).thenApply(ce -> ce != null && version.equals(ce.metadata().version()));
    }

    default public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version) {
        return this.getOrReplaceEntry(key, value, version, CacheWriteOptions.DEFAULT);
    }

    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    default public CompletionStage<Boolean> remove(K key) {
        return this.remove(key, CacheOptions.DEFAULT);
    }

    public CompletionStage<Boolean> remove(K var1, CacheOptions var2);

    default public CompletionStage<Boolean> remove(K key, CacheEntryVersion version) {
        return this.remove(key, version, CacheOptions.DEFAULT);
    }

    public CompletionStage<Boolean> remove(K var1, CacheEntryVersion var2, CacheOptions var3);

    default public CompletionStage<CacheEntry<K, V>> getAndRemove(K key) {
        return this.getAndRemove(key, CacheOptions.DEFAULT);
    }

    public CompletionStage<CacheEntry<K, V>> getAndRemove(K var1, CacheOptions var2);

    default public Flow.Publisher<K> keys() {
        return this.keys(CacheOptions.DEFAULT);
    }

    public Flow.Publisher<K> keys(CacheOptions var1);

    default public Flow.Publisher<CacheEntry<K, V>> entries() {
        return this.entries(CacheOptions.DEFAULT);
    }

    public Flow.Publisher<CacheEntry<K, V>> entries(CacheOptions var1);

    default public CompletionStage<Void> putAll(Map<K, V> entries) {
        return this.putAll(entries, CacheWriteOptions.DEFAULT);
    }

    public CompletionStage<Void> putAll(Map<K, V> var1, CacheWriteOptions var2);

    default public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> entries) {
        return this.putAll(entries, CacheWriteOptions.DEFAULT);
    }

    public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> var1, CacheWriteOptions var2);

    default public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> keys) {
        return this.getAll(keys, CacheOptions.DEFAULT);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> var1, CacheOptions var2);

    default public Flow.Publisher<CacheEntry<K, V>> getAll(K ... keys) {
        return this.getAll(CacheOptions.DEFAULT, keys);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAll(CacheOptions var1, K ... var2);

    default public Flow.Publisher<K> removeAll(Set<K> keys) {
        return this.removeAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Flow.Publisher<K> removeAll(Set<K> var1, CacheWriteOptions var2);

    default public Flow.Publisher<K> removeAll(Flow.Publisher<K> keys) {
        return this.removeAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Flow.Publisher<K> removeAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    default public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> keys) {
        return this.getAndRemoveAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> var1, CacheWriteOptions var2);

    default public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> keys) {
        return this.getAndRemoveAll(keys, CacheWriteOptions.DEFAULT);
    }

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    default public CompletionStage<Long> estimateSize() {
        return this.estimateSize(CacheOptions.DEFAULT);
    }

    public CompletionStage<Long> estimateSize(CacheOptions var1);

    default public CompletionStage<Void> clear() {
        return this.clear(CacheOptions.DEFAULT);
    }

    public CompletionStage<Void> clear(CacheOptions var1);

    default public <R> AsyncQuery<K, V, R> query(String query) {
        return this.query(query, CacheOptions.DEFAULT);
    }

    public <R> AsyncQuery<K, V, R> query(String var1, CacheOptions var2);

    default public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheEntryEventType ... types) {
        return this.listen(new CacheListenerOptions(), types);
    }

    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType ... var2);

    default public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> keys, AsyncCacheEntryProcessor<K, V, T> processor) {
        return this.process(keys, processor, CacheOptions.DEFAULT);
    }

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> var1, AsyncCacheEntryProcessor<K, V, T> var2, CacheOptions var3);

    default public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> processor) {
        return this.processAll(processor, CacheProcessorOptions.DEFAULT);
    }

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> var1, CacheProcessorOptions var2);

    public AsyncStreamingCache<K> streaming();
}

