/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.sdjwt.DecoyClaim;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.JwsToken;
import org.keycloak.sdjwt.SdJwtClaim;
import org.keycloak.sdjwt.SdJwtClaimFactory;
import org.keycloak.sdjwt.SdJwtClaimName;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.UndisclosedClaim;
import org.keycloak.sdjwt.VisibleSdJwtClaim;
import org.keycloak.util.JsonSerialization;

public class IssuerSignedJWT
extends JwsToken {
    private DisclosureSpec disclosureSpec;
    private List<SdJwtClaim> disclosureClaims;
    private List<DecoyClaim> decoyClaims;

    public IssuerSignedJWT(JWSHeader jwsHeader, ObjectNode payload) {
        super(jwsHeader, payload);
        this.disclosureSpec = null;
        this.disclosureClaims = new ArrayList<SdJwtClaim>();
        this.decoyClaims = new ArrayList<DecoyClaim>();
    }

    public IssuerSignedJWT(String jwsString) {
        super(jwsString);
        this.disclosureSpec = null;
        this.disclosureClaims = new ArrayList<SdJwtClaim>();
        this.decoyClaims = new ArrayList<DecoyClaim>();
    }

    protected IssuerSignedJWT(DisclosureSpec disclosureSpec, JWSHeader jwsHeader, List<SdJwtClaim> disclosureClaims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures) {
        super(jwsHeader, IssuerSignedJWT.generatePayloadString(disclosureClaims, decoyClaims, hashAlg, nestedDisclosures));
        this.disclosureSpec = disclosureSpec;
        this.disclosureClaims = disclosureClaims;
        this.decoyClaims = decoyClaims;
    }

    protected IssuerSignedJWT(DisclosureSpec disclosureSpec, JWSHeader jwsHeader, List<SdJwtClaim> disclosureClaims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures, SignatureSignerContext signer) {
        super(jwsHeader, IssuerSignedJWT.generatePayloadString(disclosureClaims, decoyClaims, hashAlg, nestedDisclosures), signer);
        this.disclosureSpec = disclosureSpec;
        this.disclosureClaims = disclosureClaims;
        this.decoyClaims = decoyClaims;
    }

    private static ObjectNode generatePayloadString(List<SdJwtClaim> claims, List<DecoyClaim> decoyClaims, String hashAlg, boolean nestedDisclosures) {
        SdJwtUtils.requireNonEmpty(hashAlg, "hashAlg must not be null or empty");
        List<Object> claimsInternal = claims == null ? Collections.emptyList() : Collections.unmodifiableList(claims);
        List<Object> decoyClaimsInternal = decoyClaims == null ? Collections.emptyList() : Collections.unmodifiableList(decoyClaims);
        try {
            claimsInternal.stream().filter(Objects::nonNull).collect(Collectors.toMap(SdJwtClaim::getClaimName, claim -> claim));
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("claims must not contain duplicate claim names", e);
        }
        ArrayNode sdArray = SdJwtUtils.mapper.createArrayNode();
        HashMap undisclosedClaimMap = new HashMap();
        claimsInternal.stream().filter(claim -> claim instanceof UndisclosedClaim).map(claim -> (UndisclosedClaim)claim).forEach(undisclosedClaim -> {
            if (undisclosedClaimMap.containsKey(undisclosedClaim.getSalt())) {
                String errorMessage = String.format("Salt value '%s' was reused for claims '%s' and '%s'", undisclosedClaim.getSalt(), undisclosedClaim.getClaimName(), ((UndisclosedClaim)undisclosedClaimMap.get(undisclosedClaim.getSalt())).getClaimName());
                throw new IllegalArgumentException(errorMessage);
            }
            undisclosedClaimMap.put(undisclosedClaim.getSalt(), undisclosedClaim);
        });
        List digests = undisclosedClaimMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).filter(Objects::nonNull).map(od -> od.getDisclosureDigest(hashAlg)).collect(Collectors.toList());
        decoyClaimsInternal.stream().map(claim -> claim.getDisclosureDigest(hashAlg)).forEach(digests::add);
        digests.stream().sorted().forEach(arg_0 -> ((ArrayNode)sdArray).add(arg_0));
        ObjectNode payload = SdJwtUtils.mapper.createObjectNode();
        if (sdArray.size() > 0) {
            payload.set("_sd", (JsonNode)sdArray);
        }
        if (sdArray.size() > 0 || nestedDisclosures) {
            payload.put("_sd_alg", hashAlg);
        }
        claimsInternal.stream().filter(Objects::nonNull).filter(claim -> !(claim instanceof UndisclosedClaim)).forEach(nullableClaim -> {
            SdJwtClaim claim = Objects.requireNonNull(nullableClaim);
            payload.set(claim.getClaimNameAsString(), claim.getVisibleClaimValue(hashAlg));
        });
        return payload;
    }

    public Optional<JsonNode> getCnfClaim() {
        JsonNode cnf = this.getPayload().get("cnf");
        return Optional.ofNullable(cnf);
    }

    public String getSdHashAlg() {
        ObjectNode payload = this.getPayload();
        return Optional.ofNullable(payload.get("_sd_alg")).map(JsonNode::textValue).orElse("sha-256");
    }

    public void verifySdHashAlgorithm() throws VerificationException {
        String hashAlg;
        HashSet<String> secureAlgorithms = new HashSet<String>(Arrays.asList("sha-256", "sha-384", "sha-512", "sha3-256", "sha3-384", "sha3-512"));
        if (!secureAlgorithms.contains(hashAlg = this.getSdHashAlg())) {
            throw new VerificationException("Unexpected or insecure hash algorithm: " + hashAlg);
        }
    }

    public DisclosureSpec getDisclosureSpec() {
        return this.disclosureSpec;
    }

    public List<SdJwtClaim> getDisclosureClaims() {
        return this.disclosureClaims;
    }

    public List<DecoyClaim> getDecoyClaims() {
        return this.decoyClaims;
    }

    public void setDisclosureClaims(DisclosureSpec disclosureSpec, List<SdJwtClaim> disclosureClaims, List<DecoyClaim> decoyClaims) {
        this.setDisclosureClaims(disclosureSpec, disclosureClaims, decoyClaims, null);
    }

    public void setDisclosureClaims(DisclosureSpec disclosureSpec, List<SdJwtClaim> disclosureClaims, List<DecoyClaim> decoyClaims, SignatureSignerContext signatureSignerContext) {
        this.disclosureSpec = disclosureSpec;
        this.disclosureClaims = disclosureClaims;
        this.decoyClaims = decoyClaims;
        super.setPayload(IssuerSignedJWT.generatePayloadString(disclosureClaims, decoyClaims, this.getSdHashAlg(), false));
        this.setJws(null);
        this.setJwsInput(null);
        Optional.ofNullable(signatureSignerContext).ifPresent(x$0 -> super.sign((SignatureSignerContext)x$0));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DisclosureSpec disclosureSpec;
        private List<SdJwtClaim> claims;
        private String hashAlg;
        private SignatureSignerContext signer;
        private List<DecoyClaim> decoyClaims;
        private boolean nestedDisclosures;
        private JWSHeader jwsHeader = new JWSHeader();

        private JWSHeader getJwsHeader() {
            if (this.jwsHeader == null) {
                this.jwsHeader = new JWSHeader();
            }
            return this.jwsHeader;
        }

        private List<SdJwtClaim> getClaims() {
            if (this.claims == null) {
                this.claims = new ArrayList<SdJwtClaim>();
            }
            return this.claims;
        }

        public Builder withClaims(List<SdJwtClaim> claims) {
            this.claims = claims;
            return this;
        }

        public Builder withClaims(ObjectNode claimsNode) {
            this.disclosureSpec = DisclosureSpec.builder().build();
            this.claims = SdJwtClaimFactory.parsePayload(claimsNode, this.disclosureSpec);
            return this;
        }

        public Builder withClaims(ObjectNode claimsNode, DisclosureSpec disclosureSpec) {
            this.disclosureSpec = disclosureSpec;
            this.claims = SdJwtClaimFactory.parsePayload(claimsNode, disclosureSpec);
            return this;
        }

        public Builder withDecoyClaims(List<DecoyClaim> decoyClaims) {
            this.decoyClaims = decoyClaims;
            return this;
        }

        public Builder withHashAlg(String hashAlg) {
            this.hashAlg = hashAlg;
            return this;
        }

        public Builder withSigner(SignatureSignerContext signer) {
            this.signer = signer;
            return this;
        }

        public Builder withNestedDisclosures(boolean nestedDisclosures) {
            this.nestedDisclosures = nestedDisclosures;
            return this;
        }

        public Builder withJwsType(String jwsType) {
            if (this.jwsHeader == null) {
                this.jwsHeader = new JWSHeader();
            }
            this.jwsHeader.setType(jwsType);
            return this;
        }

        public Builder withJwsHeader(JWSHeader jwsHeader) {
            String jwsType = Optional.ofNullable(this.jwsHeader).map(JWSHeader::getType).orElse(null);
            this.jwsHeader = jwsHeader;
            if (this.jwsHeader != null) {
                this.jwsHeader.setType(jwsType);
            }
            return this;
        }

        public Builder withKid(String kid) {
            this.getJwsHeader().setKeyId(kid);
            return this;
        }

        public Builder withX5c(List<String> x5c) {
            this.getJwsHeader().setX5c(x5c);
            return this;
        }

        public Builder withX5c(String x5c) {
            this.getJwsHeader().addX5c(x5c);
            return this;
        }

        public Builder withX5c(Certificate x5c) {
            this.getJwsHeader().addX5c(x5c);
            return this;
        }

        public Builder withIat(long iat) {
            this.getClaims().add(new VisibleSdJwtClaim(SdJwtClaimName.of("iat"), (JsonNode)new LongNode(iat)));
            return this;
        }

        public Builder withNbf(long nbf) {
            this.getClaims().add(new VisibleSdJwtClaim(SdJwtClaimName.of("nbf"), (JsonNode)new LongNode(nbf)));
            return this;
        }

        public Builder withExp(long exp) {
            this.getClaims().add(new VisibleSdJwtClaim(SdJwtClaimName.of("exp"), (JsonNode)new LongNode(exp)));
            return this;
        }

        public Builder withKeyBindingKey(JWK keyBinding) {
            ObjectNode jwkNode = (ObjectNode)JsonSerialization.mapper.convertValue((Object)keyBinding, ObjectNode.class);
            ObjectNode cnf = JsonNodeFactory.instance.objectNode();
            cnf.set("jwk", (JsonNode)jwkNode);
            this.getClaims().add(new VisibleSdJwtClaim(SdJwtClaimName.of("cnf"), (JsonNode)cnf));
            return this;
        }

        public Builder withClaim(SdJwtClaim sdJwtClaim) {
            this.getClaims().add(sdJwtClaim);
            return this;
        }

        public IssuerSignedJWT build() {
            this.hashAlg = this.hashAlg == null ? "sha-256" : this.hashAlg;
            this.jwsHeader.setType(this.jwsHeader.getType() == null ? "dc+sd-jwt" : this.jwsHeader.getType());
            this.disclosureSpec = Optional.ofNullable(this.disclosureSpec).orElseGet(() -> DisclosureSpec.builder().build());
            List<DecoyClaim> list = this.decoyClaims = this.decoyClaims == null ? this.disclosureSpec.createDecoyClaims() : this.decoyClaims;
            if (this.signer != null) {
                return new IssuerSignedJWT(this.disclosureSpec, this.jwsHeader, this.claims, this.decoyClaims, this.hashAlg, this.nestedDisclosures, this.signer);
            }
            return new IssuerSignedJWT(this.disclosureSpec, this.jwsHeader, this.claims, this.decoyClaims, this.hashAlg, this.nestedDisclosures);
        }
    }
}

