/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.stream.Stream;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.utils.StringUtil;

public class IdentityProviderWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final String expectedAlias;
    private final KeycloakSession session;

    public IdentityProviderWorkflowConditionProvider(KeycloakSession session, String expectedAlias) {
        this.session = session;
        this.expectedAlias = expectedAlias;
    }

    public boolean evaluate(WorkflowExecutionContext context) {
        this.validate();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user == null) {
            return false;
        }
        Stream federatedIdentities = this.session.users().getFederatedIdentitiesStream(realm, user);
        return federatedIdentities.map(FederatedIdentityModel::getIdentityProvider).anyMatch(this.expectedAlias::equals);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> path) {
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(FederatedIdentityEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)from.get("user").get("id"), (Expression)path.get("id")), (Expression)cb.equal((Expression)from.get("identityProvider"), (Object)this.expectedAlias)));
        return cb.exists(subquery);
    }

    public void validate() {
        if (StringUtil.isBlank((String)this.expectedAlias)) {
            throw new WorkflowInvalidStateException("Expected identity provider alias is not set.");
        }
        if (this.session.identityProviders().getByAlias(this.expectedAlias) == null) {
            throw new WorkflowInvalidStateException(String.format("Identity provider %s does not exist.", this.expectedAlias));
        }
    }

    public void close() {
    }
}

