/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.StandardTypes;
import org.jetbrains.kotlin.fir.analysis.checkers.ClassSymbolAndProjections;
import org.jetbrains.kotlin.fir.analysis.checkers.FE10LikeConeSubstitutor;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aU\u0010\u0000\u001a\u00020\u00012\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\b0\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000f\u001aE\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\b0\u0007H\u0002R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"checkInconsistentTypeParameters", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "firTypeRefClasses", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isValues", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;Lorg/jetbrains/kotlin/KtSourceElement;Z)V", "buildDeepSubstitutionMultimap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/ClassSymbolAndProjections;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/util/List;)Ljava/util/Map;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInconsistentTypeParameterHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInconsistentTypeParameterHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirInconsistentTypeParameterHelpersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n1586#2:114\n1661#2,3:115\n2792#2,3:125\n383#3,7:118\n*S KotlinDebug\n*F\n+ 1 FirInconsistentTypeParameterHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirInconsistentTypeParameterHelpersKt\n*L\n40#1:114\n40#1:115,3\n78#1:125,3\n73#1:118,7\n*E\n"})
public final class FirInconsistentTypeParameterHelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void checkInconsistentTypeParameters(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull List<? extends Pair<? extends FirTypeRef, ? extends FirClassSymbol<?>>> firTypeRefClasses, @Nullable KtSourceElement source, boolean isValues) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(firTypeRefClasses, "firTypeRefClasses");
        Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2 = FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap(context2, firTypeRefClasses);
        for (Map.Entry<FirTypeParameterSymbol, ClassSymbolAndProjections> entry : result2.entrySet()) {
            Collection<ConeKotlinType> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            FirTypeParameterSymbol typeParameterSymbol = entry.getKey();
            ClassSymbolAndProjections typeAndProjections = entry.getValue();
            List<ConeTypeProjection> projections = typeAndProjections.getProjections();
            if (projections.size() <= 1) continue;
            KtDiagnosticFactory3<FirTypeParameterSymbol, FirClassSymbol<?>, Collection<ConeKotlinType>> diagnosticFactory = isValues ? FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_VALUES() : FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETER_BOUNDS();
            Iterable iterable = projections;
            FirClassSymbol<?> firClassSymbol = typeAndProjections.getClassSymbol();
            FirTypeParameterSymbol firTypeParameterSymbol = typeParameterSymbol;
            KtDiagnosticFactory3<FirTypeParameterSymbol, FirClassSymbol<?>, Collection<ConeKotlinType>> ktDiagnosticFactory3 = diagnosticFactory;
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            DiagnosticContext diagnosticContext2 = context2;
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConeTypeProjection coneTypeProjection = (ConeTypeProjection)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)it);
                if (coneKotlinType == null) {
                    coneKotlinType = StandardTypes.INSTANCE.getNullableAny();
                }
                collection.add(coneKotlinType);
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext2, diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory3, (Object)firTypeParameterSymbol, firClassSymbol, (Object)collection, null, 64, null);
        }
    }

    private static final Map<FirTypeParameterSymbol, ClassSymbolAndProjections> buildDeepSubstitutionMultimap(CheckerContext context2, List<? extends Pair<? extends FirTypeRef, ? extends FirClassSymbol<?>>> firTypeRefClasses) {
        Map result2 = new LinkedHashMap();
        Map substitution = new LinkedHashMap();
        FirSession session = context2.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session);
        FE10LikeConeSubstitutor substitutor2 = new FE10LikeConeSubstitutor(substitution, session);
        Set visitedSupertypes = new LinkedHashSet();
        for (Pair<FirTypeRef, FirClassSymbol<?>> pair : firTypeRefClasses) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType2;
            FirTypeRef typeRef = pair.component1();
            FirClassSymbol<?> regularClassSymbol = pair.component2();
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(context2, substitutor2, substitution, result2, visitedSupertypes, typeContext2, typeRef != null && (coneKotlinType2 = FirTypeUtilsKt.getConeType(typeRef)) != null && (coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, coneKotlinType2)) != null ? coneKotlinType.getTypeArguments() : null, regularClassSymbol);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildDeepSubstitutionMultimap$fillInDeepSubstitutor(CheckerContext context2, FE10LikeConeSubstitutor substitutor2, Map<FirTypeParameterSymbol, ConeTypeProjection> substitution, Map<FirTypeParameterSymbol, ClassSymbolAndProjections> result2, Set<ConeKotlinType> visitedSupertypes, ConeInferenceContext typeContext2, ConeTypeProjection[] typeArguments, FirClassSymbol<?> classSymbol) {
        if (typeArguments != null) {
            List<FirTypeParameterSymbol> typeParameterSymbols = classSymbol.getTypeParameterSymbols();
            int count = Math.min(typeArguments.length, typeParameterSymbols.size());
            for (int index = 0; index < count; ++index) {
                boolean bl;
                List<ConeTypeProjection> projections;
                ConeTypeProjection substitutedArgument;
                block11: {
                    Object object;
                    void $this$getOrPut$iv;
                    ConeTypeProjection typeArgument = typeArguments[index];
                    ConeTypeProjection coneTypeProjection = substitutor2.substituteArgument(typeArgument, index);
                    if (coneTypeProjection == null) {
                        coneTypeProjection = typeArgument;
                    }
                    substitutedArgument = coneTypeProjection;
                    FirTypeParameterSymbol typeParameterSymbol = typeParameterSymbols.get(index);
                    substitution.put(typeParameterSymbol, substitutedArgument);
                    Map<FirTypeParameterSymbol, ClassSymbolAndProjections> map = result2;
                    FirTypeParameterSymbol key$iv = typeParameterSymbol;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        ClassSymbolAndProjections answer$iv = new ClassSymbolAndProjections(classSymbol, new ArrayList());
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    projections = ((ClassSymbolAndProjections)object).getProjections();
                    ConeKotlinType substitutedArgumentType = ConeTypeProjectionKt.getType(substitutedArgument);
                    Iterable $this$none$iv = projections;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            boolean bl3;
                            ConeTypeProjection it = (ConeTypeProjection)element$iv;
                            boolean bl4 = false;
                            if (substitutedArgumentType == null || ConeTypeProjectionKt.getType(it) == null) {
                                bl3 = it == substitutedArgument;
                            } else {
                                TypeCheckerProviderContext typeCheckerProviderContext = typeContext2;
                                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(it);
                                Intrinsics.checkNotNull(coneKotlinType);
                                bl3 = AbstractTypeChecker.equalTypes$default(AbstractTypeChecker.INSTANCE, typeCheckerProviderContext, coneKotlinType, substitutedArgumentType, false, false, 24, null);
                            }
                            if (!bl3) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                projections.add(substitutedArgument);
            }
        }
        for (FirResolvedTypeRef superTypeRef : classSymbol.getResolvedSuperTypeRefs()) {
            ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, superTypeRef.getConeType());
            if (!visitedSupertypes.add(fullyExpandedType2)) continue;
            FirRegularClassSymbol superClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, fullyExpandedType2);
            if (ConeBuiltinTypeUtilsKt.isEnum(fullyExpandedType2) || superClassSymbol == null) continue;
            FirInconsistentTypeParameterHelpersKt.buildDeepSubstitutionMultimap$fillInDeepSubstitutor(context2, substitutor2, substitution, result2, visitedSupertypes, typeContext2, fullyExpandedType2.getTypeArguments(), superClassSymbol);
        }
    }
}

