/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class BeamSet extends Base {

	public BeamSet(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Sets a beamset's name string
	 *
	 * @param name new name of the beamset.
	 * @throws Lib3MFException
	 */
	public void setName(String name) throws Lib3MFException {
		byte[] bytesName = name.getBytes(StandardCharsets.UTF_8);
		Memory bufferName = new Memory(bytesName.length + 1);
		bufferName.write(0, bytesName, 0, bytesName.length);
		bufferName.setByte(bytesName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_setname.invokeInt(new java.lang.Object[]{mHandle, bufferName}));
	}

	/**
	 * Retrieves a beamset's name string
	 *
	 * @return returns the name of the beamset.
	 * @throws Lib3MFException
	 */
	public String getName() throws Lib3MFException {
		Pointer bytesNeededName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededName, null}));
		int sizeName = bytesNeededName.getInt(0);
		Pointer bufferName = new Memory(sizeName);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getname.invokeInt(new java.lang.Object[]{mHandle, sizeName, bytesNeededName, bufferName}));
		return new String(bufferName.getByteArray(0, sizeName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets a beamset's identifier string
	 *
	 * @param identifier new name of the beamset.
	 * @throws Lib3MFException
	 */
	public void setIdentifier(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_setidentifier.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier}));
	}

	/**
	 * Retrieves a beamset's identifier string
	 *
	 * @return returns the identifier of the beamset.
	 * @throws Lib3MFException
	 */
	public String getIdentifier() throws Lib3MFException {
		Pointer bytesNeededIdentifier = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getidentifier.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededIdentifier, null}));
		int sizeIdentifier = bytesNeededIdentifier.getInt(0);
		Pointer bufferIdentifier = new Memory(sizeIdentifier);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getidentifier.invokeInt(new java.lang.Object[]{mHandle, sizeIdentifier, bytesNeededIdentifier, bufferIdentifier}));
		return new String(bufferIdentifier.getByteArray(0, sizeIdentifier - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Retrieves the reference count of a beamset
	 *
	 * @return returns the reference count
	 * @throws Lib3MFException
	 */
	public int getReferenceCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getreferencecount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Sets the references of a beamset
	 *
	 * @param references the new indices of all beams in this beamset
	 * @throws Lib3MFException
	 */
	public void setReferences(int[] references) throws Lib3MFException {
		Pointer bufferReferences = new Memory(Math.max(1, 4 * references.length));
		for (int i = 0; i < references.length; i++) {
		  bufferReferences.setInt(4 * i, references[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_setreferences.invokeInt(new java.lang.Object[]{mHandle, (long) references.length, bufferReferences}));
	}

	/**
	 * Retrieves the references of a beamset
	 *
	 * @return retrieves the indices of all beams in this beamset
	 * @throws Lib3MFException
	 */
	public int[] getReferences() throws Lib3MFException {
		Pointer countNeededReferences = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getreferences.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededReferences, Pointer.NULL}));
		long countReferences = countNeededReferences.getLong(0);
		Pointer bufferReferences = new Memory(Math.max(1, 4 * countReferences));
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getreferences.invokeInt(new java.lang.Object[]{mHandle, countReferences, countNeededReferences, bufferReferences}));
		return bufferReferences.getIntArray(0, (int)countReferences);
	}

	/**
	 * Retrieves the ball reference count of a beamset
	 *
	 * @return returns the ball reference count
	 * @throws Lib3MFException
	 */
	public int getBallReferenceCount() throws Lib3MFException {
		Pointer bufferCount = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getballreferencecount.invokeInt(new java.lang.Object[]{mHandle, bufferCount}));
		return bufferCount.getInt(0);
	}

	/**
	 * Sets the ball references of a beamset
	 *
	 * @param ballReferences the new indices of all balls in this beamset
	 * @throws Lib3MFException
	 */
	public void setBallReferences(int[] ballReferences) throws Lib3MFException {
		Pointer bufferBallReferences = new Memory(Math.max(1, 4 * ballReferences.length));
		for (int i = 0; i < ballReferences.length; i++) {
		  bufferBallReferences.setInt(4 * i, ballReferences[i]);
		}
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_setballreferences.invokeInt(new java.lang.Object[]{mHandle, (long) ballReferences.length, bufferBallReferences}));
	}

	/**
	 * Retrieves the ball references of a beamset
	 *
	 * @return retrieves the indices of all balls in this beamset
	 * @throws Lib3MFException
	 */
	public int[] getBallReferences() throws Lib3MFException {
		Pointer countNeededBallReferences = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getballreferences.invokeInt(new java.lang.Object[]{mHandle, 0L, countNeededBallReferences, Pointer.NULL}));
		long countBallReferences = countNeededBallReferences.getLong(0);
		Pointer bufferBallReferences = new Memory(Math.max(1, 4 * countBallReferences));
		mWrapper.checkError(this, mWrapper.lib3mf_beamset_getballreferences.invokeInt(new java.lang.Object[]{mHandle, countBallReferences, countNeededBallReferences, bufferBallReferences}));
		return bufferBallReferences.getIntArray(0, (int)countBallReferences);
	}


}

