/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.memorycontainer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchParseException;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public class MemoryConfiguration
implements ToXContentObject,
Writeable {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryConfiguration.class);
    private String indexPrefix;
    private FunctionName embeddingModelType;
    private String embeddingModelId;
    private String llmId;
    private Integer dimension;
    private Integer maxInferSize;
    private List<MemoryStrategy> strategies;
    private Map<String, Map<String, Object>> indexSettings;
    private Map<String, Object> parameters;
    private boolean disableHistory;
    private boolean disableSession;
    private boolean useSystemIndex;
    private String tenantId;

    public MemoryConfiguration(String indexPrefix, FunctionName embeddingModelType, String embeddingModelId, String llmId, Integer dimension, Integer maxInferSize, List<MemoryStrategy> strategies, Map<String, Map<String, Object>> indexSettings, Map<String, Object> parameters, boolean disableHistory, boolean disableSession, boolean useSystemIndex, String tenantId) {
        MemoryConfiguration.validateInputs(embeddingModelType, embeddingModelId, dimension, maxInferSize);
        this.indexPrefix = this.buildIndexPrefix(indexPrefix, useSystemIndex);
        this.embeddingModelType = embeddingModelType;
        this.embeddingModelId = embeddingModelId;
        this.llmId = llmId;
        this.dimension = dimension;
        this.maxInferSize = llmId != null ? Integer.valueOf(maxInferSize != null ? maxInferSize : 5) : null;
        this.strategies = new ArrayList<MemoryStrategy>();
        if (strategies != null && !strategies.isEmpty()) {
            this.strategies.addAll(strategies);
        }
        this.indexSettings = new HashMap<String, Map<String, Object>>();
        if (indexSettings != null && !indexSettings.isEmpty()) {
            this.indexSettings.putAll(indexSettings);
        }
        this.parameters = new HashMap<String, Object>();
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
        this.disableHistory = disableHistory;
        this.disableSession = disableSession;
        this.useSystemIndex = useSystemIndex;
        this.tenantId = tenantId;
    }

    private String buildIndexPrefix(String indexPrefix, boolean useSystemIndex) {
        if (indexPrefix == null || indexPrefix.isBlank()) {
            return useSystemIndex ? "default" : UUID.randomUUID().toString().replace("-", "").substring(0, 8).toLowerCase();
        }
        if (indexPrefix.indexOf(13) >= 0 || indexPrefix.indexOf(10) >= 0 || indexPrefix.chars().anyMatch(ch -> ch < 32)) {
            throw new OpenSearchParseException("Index prefix must not contain any control characters", new Object[0]);
        }
        MetadataCreateIndexService.validateIndexOrAliasName((String)indexPrefix, (s1, s2) -> new OpenSearchParseException("missing or invalid index prefix [" + s1 + "] " + s2, new Object[0]));
        return indexPrefix;
    }

    public MemoryConfiguration(StreamInput input) throws IOException {
        this.indexPrefix = input.readOptionalString();
        String embeddingModelTypeStr = input.readOptionalString();
        this.embeddingModelType = embeddingModelTypeStr != null ? FunctionName.from(embeddingModelTypeStr) : null;
        this.embeddingModelId = input.readOptionalString();
        this.llmId = input.readOptionalString();
        this.dimension = input.readOptionalInt();
        this.maxInferSize = input.readOptionalInt();
        if (input.readBoolean()) {
            this.strategies = input.readList(MemoryStrategy::new);
        }
        if (input.readBoolean()) {
            this.indexSettings = input.readMap(StreamInput::readString, StreamInput::readMap);
        }
        if (input.readBoolean()) {
            this.parameters = input.readMap();
        }
        this.disableHistory = input.readBoolean();
        this.disableSession = input.readBoolean();
        this.useSystemIndex = input.readBoolean();
        this.tenantId = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.indexPrefix);
        out.writeOptionalString(this.embeddingModelType != null ? this.embeddingModelType.name() : null);
        out.writeOptionalString(this.embeddingModelId);
        out.writeOptionalString(this.llmId);
        out.writeOptionalInt(this.dimension);
        out.writeOptionalInt(this.maxInferSize);
        if (!this.strategies.isEmpty()) {
            out.writeBoolean(true);
            out.writeList(this.strategies);
        } else {
            out.writeBoolean(false);
        }
        if (!this.indexSettings.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.indexSettings, StreamOutput::writeString, StreamOutput::writeMap);
        } else {
            out.writeBoolean(false);
        }
        if (!this.parameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.parameters);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.disableHistory);
        out.writeBoolean(this.disableSession);
        out.writeBoolean(this.useSystemIndex);
        out.writeOptionalString(this.tenantId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexPrefix != null) {
            builder.field("index_prefix", this.indexPrefix);
        }
        if (this.llmId != null) {
            builder.field("llm_id", this.llmId);
        }
        if (this.embeddingModelType != null) {
            builder.field("embedding_model_type", this.embeddingModelType.name());
        }
        if (this.embeddingModelId != null) {
            builder.field("embedding_model_id", this.embeddingModelId);
        }
        if (this.embeddingModelType == FunctionName.SPARSE_ENCODING) {
            builder.field("embedding_dimension", (Integer)null);
        } else if (this.dimension != null) {
            builder.field("embedding_dimension", this.dimension);
        }
        if (this.llmId != null && this.maxInferSize != null) {
            builder.field("max_infer_size", this.maxInferSize);
        }
        if (this.strategies != null && !this.strategies.isEmpty()) {
            builder.field("strategies", this.strategies);
        }
        if (!this.indexSettings.isEmpty()) {
            builder.field("index_settings", this.indexSettings);
        }
        if (!this.parameters.isEmpty()) {
            builder.field("parameters", this.parameters);
        }
        builder.field("disable_history", this.disableHistory);
        builder.field("disable_session", this.disableSession);
        builder.field("use_system_index", this.useSystemIndex);
        if (this.tenantId != null) {
            builder.field("tenant_id", this.tenantId);
        }
        builder.endObject();
        return builder;
    }

    public static MemoryConfiguration parse(XContentParser parser) throws IOException {
        String indexPrefix = null;
        FunctionName embeddingModelType = null;
        String embeddingModelId = null;
        String llmId = null;
        Integer dimension = null;
        Integer maxInferSize = null;
        ArrayList<MemoryStrategy> strategies = new ArrayList<MemoryStrategy>();
        Map<String, Map<String, Object>> indexSettings = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> parameters = new HashMap();
        boolean disableHistory = false;
        boolean disableSession = false;
        boolean useSystemIndex = true;
        String tenantId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block28: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "index_prefix": {
                    indexPrefix = parser.text();
                    continue block28;
                }
                case "embedding_model_type": {
                    embeddingModelType = FunctionName.from(parser.text());
                    continue block28;
                }
                case "embedding_model_id": {
                    embeddingModelId = parser.text();
                    continue block28;
                }
                case "llm_id": {
                    llmId = parser.text();
                    continue block28;
                }
                case "embedding_dimension": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                        dimension = null;
                        continue block28;
                    }
                    dimension = parser.intValue();
                    continue block28;
                }
                case "max_infer_size": {
                    maxInferSize = parser.intValue();
                    continue block28;
                }
                case "strategies": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        strategies.add(MemoryStrategy.parse(parser));
                    }
                    continue block28;
                }
                case "index_settings": {
                    indexSettings = parser.map(HashMap::new, p -> p.map());
                    continue block28;
                }
                case "parameters": {
                    parameters = parser.map();
                    continue block28;
                }
                case "disable_history": {
                    disableHistory = parser.booleanValue();
                    continue block28;
                }
                case "disable_session": {
                    disableSession = parser.booleanValue();
                    continue block28;
                }
                case "use_system_index": {
                    useSystemIndex = parser.booleanValue();
                    continue block28;
                }
            }
            parser.skipChildren();
        }
        return MemoryConfiguration.builder().indexPrefix(indexPrefix).embeddingModelType(embeddingModelType).embeddingModelId(embeddingModelId).llmId(llmId).dimension(dimension).maxInferSize(maxInferSize).strategies(strategies).indexSettings(indexSettings).parameters(parameters).disableHistory(disableHistory).disableSession(disableSession).useSystemIndex(useSystemIndex).tenantId(tenantId).build();
    }

    public String getFinalMemoryIndexPrefix() {
        if (this.useSystemIndex) {
            return ".plugins-ml-am-" + this.indexPrefix + "-memory-";
        }
        return this.indexPrefix + "-memory-";
    }

    public String getIndexName(MemoryType memoryType) {
        if (memoryType == null) {
            return null;
        }
        if (memoryType == MemoryType.SESSIONS && this.isDisableSession()) {
            return null;
        }
        if (memoryType == MemoryType.HISTORY && this.isDisableHistory()) {
            return null;
        }
        return this.getFinalMemoryIndexPrefix() + memoryType.getIndexSuffix();
    }

    public String getSessionIndexName() {
        return this.getIndexName(MemoryType.SESSIONS);
    }

    public String getWorkingMemoryIndexName() {
        return this.getIndexName(MemoryType.WORKING);
    }

    public String getLongMemoryIndexName() {
        return this.getIndexName(MemoryType.LONG_TERM);
    }

    public String getLongMemoryHistoryIndexName() {
        return this.getIndexName(MemoryType.HISTORY);
    }

    public Map<String, Object> getMemoryIndexMapping(String indexName) {
        Map<String, Map<String, Object>> indexSettings = this.getIndexSettings();
        if (indexSettings != null) {
            return indexSettings.get(indexName);
        }
        return null;
    }

    public void validate() {
        MemoryConfiguration.validateInputs(this.embeddingModelType, this.embeddingModelId, this.dimension, this.maxInferSize);
    }

    private static void validateInputs(FunctionName embeddingModelType, String embeddingModelId, Integer dimension, Integer maxInferSize) {
        MemoryConfiguration.validateEmbeddingConfiguration(embeddingModelType, embeddingModelId, dimension);
        MemoryConfiguration.validateMaxInferSize(maxInferSize);
    }

    private static void validateEmbeddingConfiguration(FunctionName embeddingModelType, String embeddingModelId, Integer dimension) {
        if (embeddingModelId != null && embeddingModelType == null) {
            throw new IllegalArgumentException("Embedding model type is required when embedding model ID is provided");
        }
        if (embeddingModelType != null && embeddingModelId == null) {
            throw new IllegalArgumentException("Embedding model ID is required when embedding model type is provided");
        }
        if (embeddingModelType != null) {
            MemoryConfiguration.validateEmbeddingModelType(embeddingModelType);
            MemoryConfiguration.validateDimensionRequirements(embeddingModelType, dimension);
        }
    }

    private static void validateMaxInferSize(Integer maxInferSize) {
        if (maxInferSize != null && maxInferSize > 10) {
            throw new IllegalArgumentException("Maximum infer size cannot exceed 10");
        }
    }

    private static void validateEmbeddingModelType(FunctionName embeddingModelType) {
        if (embeddingModelType != FunctionName.TEXT_EMBEDDING && embeddingModelType != FunctionName.SPARSE_ENCODING) {
            throw new IllegalArgumentException("Embedding model type must be either TEXT_EMBEDDING or SPARSE_ENCODING");
        }
    }

    private static void validateDimensionRequirements(FunctionName embeddingModelType, Integer dimension) {
        if (embeddingModelType == FunctionName.TEXT_EMBEDDING && dimension == null) {
            throw new IllegalArgumentException("Dimension is required for TEXT_EMBEDDING");
        }
        if (embeddingModelType == FunctionName.SPARSE_ENCODING && dimension != null) {
            throw new IllegalArgumentException("Dimension is not allowed for SPARSE_ENCODING");
        }
    }

    public static void validateStrategiesRequireModels(MemoryConfiguration config) {
        boolean hasEmbedding;
        if (config == null || config.getStrategies() == null || config.getStrategies().isEmpty()) {
            return;
        }
        boolean hasLlm = config.getLlmId() != null;
        boolean bl = hasEmbedding = config.getEmbeddingModelId() != null && config.getEmbeddingModelType() != null;
        if (!hasLlm || !hasEmbedding) {
            String missing = !hasLlm && !hasEmbedding ? "LLM model and embedding model" : (!hasLlm ? "LLM model (llm_id)" : "embedding model (embedding_model_id, embedding_model_type, dimension)");
            throw new IllegalArgumentException(String.format("Strategies require both an LLM model and embedding model to be configured. Missing: %s. Strategies use LLM for fact extraction and embedding model for semantic search.", missing));
        }
    }

    public void update(MemoryConfiguration updateContent) {
        if (updateContent.getLlmId() != null) {
            this.llmId = updateContent.getLlmId();
        }
        if (updateContent.getStrategies() != null && !updateContent.getStrategies().isEmpty()) {
            this.strategies = updateContent.getStrategies();
        }
        if (updateContent.getMaxInferSize() != null) {
            this.maxInferSize = updateContent.getMaxInferSize();
        }
        if (updateContent.getEmbeddingModelId() != null) {
            this.embeddingModelId = updateContent.getEmbeddingModelId();
        }
        if (updateContent.getEmbeddingModelType() != null) {
            this.embeddingModelType = updateContent.getEmbeddingModelType();
        }
        if (this.embeddingModelType == FunctionName.SPARSE_ENCODING) {
            this.dimension = null;
        } else if (updateContent.getDimension() != null) {
            this.dimension = updateContent.getDimension();
        }
    }

    public static EmbeddingConfig extractEmbeddingConfigFromMapping(Map<String, Object> mappingProperties) {
        if (mappingProperties == null) {
            return null;
        }
        Map<String, Object> fieldMap = MemoryConfiguration.asMap(mappingProperties.get("memory_embedding"));
        if (fieldMap == null) {
            log.debug("Embedding field 'memory_embedding' is null or not a Map");
            return null;
        }
        String type = (String)fieldMap.get("type");
        if ("knn_vector".equals(type)) {
            Integer dimension = (Integer)fieldMap.get("dimension");
            return new EmbeddingConfig(FunctionName.TEXT_EMBEDDING, dimension);
        }
        if ("rank_features".equals(type)) {
            return new EmbeddingConfig(FunctionName.SPARSE_ENCODING, null);
        }
        return null;
    }

    public static Map<String, Object> asMap(Object obj) {
        return obj instanceof Map ? (Map)obj : null;
    }

    public static List<?> asList(Object obj) {
        return obj instanceof List ? (List)obj : null;
    }

    public static String extractModelIdFromPipeline(Map<String, Object> pipelineSource) {
        if (pipelineSource == null) {
            return null;
        }
        try {
            List<?> processors = MemoryConfiguration.asList(pipelineSource.get("processors"));
            if (processors == null || processors.isEmpty()) {
                log.debug("Pipeline processors list is {} - no embedding processor found", (Object)(processors == null ? "null" : "empty"));
                return null;
            }
            for (Object processorObj : processors) {
                Object modelId;
                Map<String, Object> config;
                Map<String, Object> processor = MemoryConfiguration.asMap(processorObj);
                if (processor == null) continue;
                if (processor.containsKey("text_embedding") && (config = MemoryConfiguration.asMap(processor.get("text_embedding"))) != null && (modelId = config.get("model_id")) instanceof String) {
                    return (String)modelId;
                }
                if (!processor.containsKey("sparse_encoding") || (config = MemoryConfiguration.asMap(processor.get("sparse_encoding"))) == null) continue;
                modelId = config.get("model_id");
                if (modelId instanceof String) {
                    return (String)modelId;
                }
                log.warn("Pipeline sparse_encoding model_id is not a String: {}", (Object)(modelId != null ? modelId.getClass().getSimpleName() : "null"));
            }
            return null;
        }
        catch (Exception e) {
            log.error("Unexpected error extracting model_id from pipeline: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static void compareEmbeddingConfig(MemoryConfiguration requested, String existingModelId, EmbeddingConfig existingConfig) {
        FunctionName existingType;
        FunctionName requestedType;
        ArrayList<String> mismatches = new ArrayList<String>();
        String requestedModelId = requested.getEmbeddingModelId();
        if (requestedModelId == null || !requestedModelId.equals(existingModelId)) {
            mismatches.add(String.format("  \u2022 embedding_model_id: existing='%s', requested='%s'", existingModelId, requestedModelId != null ? requestedModelId : "null"));
        }
        if ((requestedType = requested.getEmbeddingModelType()) != (existingType = existingConfig.getType())) {
            mismatches.add(String.format("  \u2022 embedding_model_type: existing='%s', requested='%s'", existingType != null ? existingType : "null", requestedType != null ? requestedType : "null"));
        }
        if (requested.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
            Integer requestedDim = requested.getDimension();
            Integer existingDim = existingConfig.getDimension();
            if (requestedDim == null || existingDim == null || !requestedDim.equals(existingDim)) {
                mismatches.add(String.format("  \u2022 dimension: existing=%s, requested=%s", existingDim != null ? existingDim.toString() : "null", requestedDim != null ? requestedDim.toString() : "null"));
            }
        }
        if (!mismatches.isEmpty()) {
            throw new IllegalArgumentException("Cannot create memory container: Embedding configuration conflicts with existing shared index.\n\nIndex prefix '" + requested.getIndexPrefix() + "' is already in use with different settings:\n" + String.join((CharSequence)"\n", mismatches) + "\n\nThis shared index was configured with:\n  embedding_model_id: \"" + existingModelId + "\"\n  embedding_model_type: \"" + String.valueOf((Object)existingConfig.getType()) + "\"" + (String)(existingConfig.getDimension() != null ? "\n  dimension: " + existingConfig.getDimension() : "") + "\n\nTo resolve this issue, you can either:\n1. Use a different index_prefix for this container\n2. Match the existing configuration in your request");
        }
    }

    @Generated
    private static Integer $default$maxInferSize() {
        return 5;
    }

    @Generated
    private static Map<String, Map<String, Object>> $default$indexSettings() {
        return new HashMap<String, Map<String, Object>>();
    }

    @Generated
    private static Map<String, Object> $default$parameters() {
        return new HashMap<String, Object>();
    }

    @Generated
    private static boolean $default$disableHistory() {
        return false;
    }

    @Generated
    private static boolean $default$disableSession() {
        return false;
    }

    @Generated
    private static boolean $default$useSystemIndex() {
        return true;
    }

    @Generated
    public static MemoryConfigurationBuilder builder() {
        return new MemoryConfigurationBuilder();
    }

    @Generated
    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    @Generated
    public FunctionName getEmbeddingModelType() {
        return this.embeddingModelType;
    }

    @Generated
    public String getEmbeddingModelId() {
        return this.embeddingModelId;
    }

    @Generated
    public String getLlmId() {
        return this.llmId;
    }

    @Generated
    public Integer getDimension() {
        return this.dimension;
    }

    @Generated
    public Integer getMaxInferSize() {
        return this.maxInferSize;
    }

    @Generated
    public List<MemoryStrategy> getStrategies() {
        return this.strategies;
    }

    @Generated
    public Map<String, Map<String, Object>> getIndexSettings() {
        return this.indexSettings;
    }

    @Generated
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean isDisableHistory() {
        return this.disableHistory;
    }

    @Generated
    public boolean isDisableSession() {
        return this.disableSession;
    }

    @Generated
    public boolean isUseSystemIndex() {
        return this.useSystemIndex;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    @Generated
    public void setEmbeddingModelType(FunctionName embeddingModelType) {
        this.embeddingModelType = embeddingModelType;
    }

    @Generated
    public void setEmbeddingModelId(String embeddingModelId) {
        this.embeddingModelId = embeddingModelId;
    }

    @Generated
    public void setLlmId(String llmId) {
        this.llmId = llmId;
    }

    @Generated
    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    @Generated
    public void setMaxInferSize(Integer maxInferSize) {
        this.maxInferSize = maxInferSize;
    }

    @Generated
    public void setStrategies(List<MemoryStrategy> strategies) {
        this.strategies = strategies;
    }

    @Generated
    public void setIndexSettings(Map<String, Map<String, Object>> indexSettings) {
        this.indexSettings = indexSettings;
    }

    @Generated
    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setDisableHistory(boolean disableHistory) {
        this.disableHistory = disableHistory;
    }

    @Generated
    public void setDisableSession(boolean disableSession) {
        this.disableSession = disableSession;
    }

    @Generated
    public void setUseSystemIndex(boolean useSystemIndex) {
        this.useSystemIndex = useSystemIndex;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryConfiguration)) {
            return false;
        }
        MemoryConfiguration other = (MemoryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableHistory() != other.isDisableHistory()) {
            return false;
        }
        if (this.isDisableSession() != other.isDisableSession()) {
            return false;
        }
        if (this.isUseSystemIndex() != other.isUseSystemIndex()) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$maxInferSize = this.getMaxInferSize();
        Integer other$maxInferSize = other.getMaxInferSize();
        if (this$maxInferSize == null ? other$maxInferSize != null : !((Object)this$maxInferSize).equals(other$maxInferSize)) {
            return false;
        }
        String this$indexPrefix = this.getIndexPrefix();
        String other$indexPrefix = other.getIndexPrefix();
        if (this$indexPrefix == null ? other$indexPrefix != null : !this$indexPrefix.equals(other$indexPrefix)) {
            return false;
        }
        FunctionName this$embeddingModelType = this.getEmbeddingModelType();
        FunctionName other$embeddingModelType = other.getEmbeddingModelType();
        if (this$embeddingModelType == null ? other$embeddingModelType != null : !((Object)((Object)this$embeddingModelType)).equals((Object)other$embeddingModelType)) {
            return false;
        }
        String this$embeddingModelId = this.getEmbeddingModelId();
        String other$embeddingModelId = other.getEmbeddingModelId();
        if (this$embeddingModelId == null ? other$embeddingModelId != null : !this$embeddingModelId.equals(other$embeddingModelId)) {
            return false;
        }
        String this$llmId = this.getLlmId();
        String other$llmId = other.getLlmId();
        if (this$llmId == null ? other$llmId != null : !this$llmId.equals(other$llmId)) {
            return false;
        }
        List<MemoryStrategy> this$strategies = this.getStrategies();
        List<MemoryStrategy> other$strategies = other.getStrategies();
        if (this$strategies == null ? other$strategies != null : !((Object)this$strategies).equals(other$strategies)) {
            return false;
        }
        Map<String, Map<String, Object>> this$indexSettings = this.getIndexSettings();
        Map<String, Map<String, Object>> other$indexSettings = other.getIndexSettings();
        if (this$indexSettings == null ? other$indexSettings != null : !((Object)this$indexSettings).equals(other$indexSettings)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        return !(this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoryConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableHistory() ? 79 : 97);
        result = result * 59 + (this.isDisableSession() ? 79 : 97);
        result = result * 59 + (this.isUseSystemIndex() ? 79 : 97);
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $maxInferSize = this.getMaxInferSize();
        result = result * 59 + ($maxInferSize == null ? 43 : ((Object)$maxInferSize).hashCode());
        String $indexPrefix = this.getIndexPrefix();
        result = result * 59 + ($indexPrefix == null ? 43 : $indexPrefix.hashCode());
        FunctionName $embeddingModelType = this.getEmbeddingModelType();
        result = result * 59 + ($embeddingModelType == null ? 43 : ((Object)((Object)$embeddingModelType)).hashCode());
        String $embeddingModelId = this.getEmbeddingModelId();
        result = result * 59 + ($embeddingModelId == null ? 43 : $embeddingModelId.hashCode());
        String $llmId = this.getLlmId();
        result = result * 59 + ($llmId == null ? 43 : $llmId.hashCode());
        List<MemoryStrategy> $strategies = this.getStrategies();
        result = result * 59 + ($strategies == null ? 43 : ((Object)$strategies).hashCode());
        Map<String, Map<String, Object>> $indexSettings = this.getIndexSettings();
        result = result * 59 + ($indexSettings == null ? 43 : ((Object)$indexSettings).hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        return result;
    }

    @Generated
    public static class MemoryConfigurationBuilder {
        @Generated
        private String indexPrefix;
        @Generated
        private FunctionName embeddingModelType;
        @Generated
        private String embeddingModelId;
        @Generated
        private String llmId;
        @Generated
        private Integer dimension;
        @Generated
        private boolean maxInferSize$set;
        @Generated
        private Integer maxInferSize$value;
        @Generated
        private List<MemoryStrategy> strategies;
        @Generated
        private boolean indexSettings$set;
        @Generated
        private Map<String, Map<String, Object>> indexSettings$value;
        @Generated
        private boolean parameters$set;
        @Generated
        private Map<String, Object> parameters$value;
        @Generated
        private boolean disableHistory$set;
        @Generated
        private boolean disableHistory$value;
        @Generated
        private boolean disableSession$set;
        @Generated
        private boolean disableSession$value;
        @Generated
        private boolean useSystemIndex$set;
        @Generated
        private boolean useSystemIndex$value;
        @Generated
        private String tenantId;

        @Generated
        MemoryConfigurationBuilder() {
        }

        @Generated
        public MemoryConfigurationBuilder indexPrefix(String indexPrefix) {
            this.indexPrefix = indexPrefix;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder embeddingModelType(FunctionName embeddingModelType) {
            this.embeddingModelType = embeddingModelType;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder embeddingModelId(String embeddingModelId) {
            this.embeddingModelId = embeddingModelId;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder llmId(String llmId) {
            this.llmId = llmId;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder maxInferSize(Integer maxInferSize) {
            this.maxInferSize$value = maxInferSize;
            this.maxInferSize$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder strategies(List<MemoryStrategy> strategies) {
            this.strategies = strategies;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder indexSettings(Map<String, Map<String, Object>> indexSettings) {
            this.indexSettings$value = indexSettings;
            this.indexSettings$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder parameters(Map<String, Object> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder disableHistory(boolean disableHistory) {
            this.disableHistory$value = disableHistory;
            this.disableHistory$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder disableSession(boolean disableSession) {
            this.disableSession$value = disableSession;
            this.disableSession$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder useSystemIndex(boolean useSystemIndex) {
            this.useSystemIndex$value = useSystemIndex;
            this.useSystemIndex$set = true;
            return this;
        }

        @Generated
        public MemoryConfigurationBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MemoryConfiguration build() {
            Integer maxInferSize$value = this.maxInferSize$value;
            if (!this.maxInferSize$set) {
                maxInferSize$value = MemoryConfiguration.$default$maxInferSize();
            }
            Map<String, Map<String, Object>> indexSettings$value = this.indexSettings$value;
            if (!this.indexSettings$set) {
                indexSettings$value = MemoryConfiguration.$default$indexSettings();
            }
            Map<String, Object> parameters$value = this.parameters$value;
            if (!this.parameters$set) {
                parameters$value = MemoryConfiguration.$default$parameters();
            }
            boolean disableHistory$value = this.disableHistory$value;
            if (!this.disableHistory$set) {
                disableHistory$value = MemoryConfiguration.$default$disableHistory();
            }
            boolean disableSession$value = this.disableSession$value;
            if (!this.disableSession$set) {
                disableSession$value = MemoryConfiguration.$default$disableSession();
            }
            boolean useSystemIndex$value = this.useSystemIndex$value;
            if (!this.useSystemIndex$set) {
                useSystemIndex$value = MemoryConfiguration.$default$useSystemIndex();
            }
            return new MemoryConfiguration(this.indexPrefix, this.embeddingModelType, this.embeddingModelId, this.llmId, this.dimension, maxInferSize$value, this.strategies, indexSettings$value, parameters$value, disableHistory$value, disableSession$value, useSystemIndex$value, this.tenantId);
        }

        @Generated
        public String toString() {
            return "MemoryConfiguration.MemoryConfigurationBuilder(indexPrefix=" + this.indexPrefix + ", embeddingModelType=" + String.valueOf((Object)this.embeddingModelType) + ", embeddingModelId=" + this.embeddingModelId + ", llmId=" + this.llmId + ", dimension=" + this.dimension + ", maxInferSize$value=" + this.maxInferSize$value + ", strategies=" + String.valueOf(this.strategies) + ", indexSettings$value=" + String.valueOf(this.indexSettings$value) + ", parameters$value=" + String.valueOf(this.parameters$value) + ", disableHistory$value=" + this.disableHistory$value + ", disableSession$value=" + this.disableSession$value + ", useSystemIndex$value=" + this.useSystemIndex$value + ", tenantId=" + this.tenantId + ")";
        }
    }

    public static class EmbeddingConfig {
        private FunctionName type;
        private Integer dimension;

        @Generated
        public static EmbeddingConfigBuilder builder() {
            return new EmbeddingConfigBuilder();
        }

        @Generated
        public FunctionName getType() {
            return this.type;
        }

        @Generated
        public Integer getDimension() {
            return this.dimension;
        }

        @Generated
        public void setType(FunctionName type) {
            this.type = type;
        }

        @Generated
        public void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EmbeddingConfig)) {
                return false;
            }
            EmbeddingConfig other = (EmbeddingConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$dimension = this.getDimension();
            Integer other$dimension = other.getDimension();
            if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
                return false;
            }
            FunctionName this$type = this.getType();
            FunctionName other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EmbeddingConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $dimension = this.getDimension();
            result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
            FunctionName $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MemoryConfiguration.EmbeddingConfig(type=" + String.valueOf((Object)this.getType()) + ", dimension=" + this.getDimension() + ")";
        }

        @Generated
        public EmbeddingConfig(FunctionName type, Integer dimension) {
            this.type = type;
            this.dimension = dimension;
        }

        @Generated
        public EmbeddingConfig() {
        }

        @Generated
        public static class EmbeddingConfigBuilder {
            @Generated
            private FunctionName type;
            @Generated
            private Integer dimension;

            @Generated
            EmbeddingConfigBuilder() {
            }

            @Generated
            public EmbeddingConfigBuilder type(FunctionName type) {
                this.type = type;
                return this;
            }

            @Generated
            public EmbeddingConfigBuilder dimension(Integer dimension) {
                this.dimension = dimension;
                return this;
            }

            @Generated
            public EmbeddingConfig build() {
                return new EmbeddingConfig(this.type, this.dimension);
            }

            @Generated
            public String toString() {
                return "MemoryConfiguration.EmbeddingConfig.EmbeddingConfigBuilder(type=" + String.valueOf((Object)this.type) + ", dimension=" + this.dimension + ")";
            }
        }
    }
}

