# This file has been autogenerated by the pywayland scanner

# Copyright 2019 Sebastian Wick
# Copyright 2019 Erwin Burema
# Copyright 2020 AMD
# Copyright 2020-2024 Collabora, Ltd.
# Copyright 2024 Xaver Hugl
# Copyright 2022-2025 Red Hat, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wp_image_description_info_v1 import WpImageDescriptionInfoV1


class WpImageDescriptionV1(Interface):
    """Colorimetric image description

    An image description carries information about the pixel color encoding and
    its intended display and viewing environment. The image description is
    attached to a :class:`~pywayland.protocol.wayland.WlSurface` via
    :func:`WpColorManagementSurfaceV1.set_image_description()
    <pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1.set_image_description>`.
    A compositor can use this information to decode pixel values into
    colorimetrically meaningful quantities, which allows the compositor to
    transform the surface contents to become suitable for various displays and
    viewing environments.

    Note, that the :class:`WpImageDescriptionV1` object is not ready to be used
    immediately after creation. The object eventually delivers either the
    'ready' or the 'failed' event, specified in all requests creating it. The
    object is deemed "ready" after receiving the 'ready' event.

    An object which is not ready is illegal to use, it can only be destroyed.
    Any other request in this interface shall result in the 'not_ready'
    protocol error. Attempts to use an object which is not ready through other
    interfaces shall raise protocol errors defined there.

    Once created and regardless of how it was created, a
    :class:`WpImageDescriptionV1` object always refers to one fixed image
    description. It cannot change after creation.
    """

    name = "wp_image_description_v1"
    version = 1

    class error(enum.IntEnum):
        not_ready = 0
        no_information = 1

    class cause(enum.IntEnum):
        low_version = 0
        unsupported = 1
        operating_system = 2
        no_output = 3


class WpImageDescriptionV1Proxy(Proxy[WpImageDescriptionV1]):
    interface = WpImageDescriptionV1

    @WpImageDescriptionV1.request()
    def destroy(self) -> None:
        """Destroy the image description

        Destroy this object. It is safe to destroy an object which is not
        ready.

        Destroying a :class:`WpImageDescriptionV1` object has no side-effects,
        not even if a :func:`WpColorManagementSurfaceV1.set_image_description()
        <pywayland.protocol.color_management_v1.WpColorManagementSurfaceV1.set_image_description>`
        has not yet been followed by a :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>`.
        """
        self._marshal(0)
        self._destroy()

    @WpImageDescriptionV1.request(
        Argument(ArgumentType.NewId, interface=WpImageDescriptionInfoV1),
    )
    def get_information(self) -> Proxy[WpImageDescriptionInfoV1]:
        """Get information about the image description

        Creates a
        :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionInfoV1`
        object which delivers the information that makes up the image
        description.

        Not all image description protocol objects allow get_information
        request. Whether it is allowed or not is defined by the request that
        created the object. If get_information is not allowed, the protocol
        error no_information is raised.

        :returns:
            :class:`~pywayland.protocol.color_management_v1.WpImageDescriptionInfoV1`
        """
        information = self._marshal_constructor(1, WpImageDescriptionInfoV1)
        return information


class WpImageDescriptionV1Resource(Resource):
    interface = WpImageDescriptionV1

    @WpImageDescriptionV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.String),
    )
    def failed(self, cause: int, msg: str) -> None:
        """Graceful error on creating the image description

        If creating a :class:`WpImageDescriptionV1` object fails for a reason
        that is not defined as a protocol error, this event is sent.

        The requests that create image description objects define whether and
        when this can occur. Only such creation requests can trigger this
        event. This event cannot be triggered after the image description was
        successfully formed.

        Once this event has been sent, the :class:`WpImageDescriptionV1` object
        will never become ready and it can only be destroyed.

        :param cause:
            generic reason
        :type cause:
            `ArgumentType.Uint`
        :param msg:
            ad hoc human-readable explanation
        :type msg:
            `ArgumentType.String`
        """
        self._post_event(0, cause, msg)

    @WpImageDescriptionV1.event(
        Argument(ArgumentType.Uint),
    )
    def ready(self, identity: int) -> None:
        """Indication that the object is ready to be used

        Once this event has been sent, the :class:`WpImageDescriptionV1` object
        is deemed "ready". Ready objects can be used to send requests and can
        be used through other interfaces.

        Every ready :class:`WpImageDescriptionV1` protocol object refers to an
        underlying image description record in the compositor. Multiple
        protocol objects may end up referring to the same record. Clients may
        identify these "copies" by comparing their id numbers: if the numbers
        from two protocol objects are identical, the protocol objects refer to
        the same image description record. Two different image description
        records cannot have the same id number simultaneously. The id number
        does not change during the lifetime of the image description record.

        The id number is valid only as long as the protocol object is alive. If
        all protocol objects referring to the same image description record are
        destroyed, the id number may be recycled for a different image
        description record.

        Image description id number is not a protocol object id. Zero is
        reserved as an invalid id number. It shall not be possible for a client
        to refer to an image description by its id number in protocol. The id
        numbers might not be portable between Wayland connections. A compositor
        shall not send an invalid id number.

        This identity allows clients to de-duplicate image description records
        and avoid get_information request if they already have the image
        description information.

        :param identity:
            image description id number
        :type identity:
            `ArgumentType.Uint`
        """
        self._post_event(1, identity)


class WpImageDescriptionV1Global(Global):
    interface = WpImageDescriptionV1


WpImageDescriptionV1._gen_c()
WpImageDescriptionV1.proxy_class = WpImageDescriptionV1Proxy
WpImageDescriptionV1.resource_class = WpImageDescriptionV1Resource
WpImageDescriptionV1.global_class = WpImageDescriptionV1Global
