RabbitMQ `3.10.1` is a maintenance release in the `3.10.x` release series.

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release requires at least Erlang 23.2, and supports Erlang 24 and 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Enhancements

 * Classic queue message store and queue index v2 (CQv2) no longer preallocates index files.

   GitHub issue: [#4735](https://github.com/rabbitmq/rabbitmq-server/pull/4735)

 * With a lot of busy quorum queues, nodes hosting a moderate number of of leader replicas could
   experience growing memory footprint of one of the Raft implementation processes.

   GitHub issue: [#4760](https://github.com/rabbitmq/rabbitmq-server/pull/4760)

 * Re-introduced key file log rotation settings.

   Some [log rotation](https://rabbitmq.com/logging.html) settings were left behind
   during the migration to the standard runtime logger starting with 3.9.0.
   Now some key settings have been re-introduced.

   Contributed by Alex @illotum Valiushko (AWS).

   GitHub issue: [#4758](https://github.com/rabbitmq/rabbitmq-server/pull/4758)

 * Cleaned up some compiler options that are no longer relevant.

   Contributed by Péter @gomoripeti Gömöri (CloudAMQP).

   GitHub issue: [#4707](https://github.com/rabbitmq/rabbitmq-server/pull/4707)

#### Bug Fixes

 * Classic queue message store and queue index v2 (CQv2) failed with an exception
   on FreeBSD with ZFS for file system.

   GitHub issue: [#4720](https://github.com/rabbitmq/rabbitmq-server/issues/4720)

 * Nodes now make sure that [maintenance mode](https://rabbitmq.com/upgrade.html#maintenance-mode) status table exists after node boot
   as long as the feature flag is enabled.

   GitHub issue: [#4760](https://github.com/rabbitmq/rabbitmq-server/pull/4760)


### JMS Topic Exchange Plugin

#### Bug Fixes

 * "In flight" messages directed to an exchange that has just been deleted will be
   silently dropped or [returned back to the publisher](https://rabbitmq.com/publishers.html#unroutable) instead of causing an exception.

   GitHub issue: [#4696](https://github.com/rabbitmq/rabbitmq-server/pull/4696)


## Dependency Upgrades

 * `ra` upgraded from [`2.0.9` to `2.0.11`](https://github.com/rabbitmq/ra/compare/v2.0.9...v2.0.11)
 * `credentials_obfuscation` was upgraded [from v2.4.0 to v3.0.0](https://github.com/rabbitmq/credentials-obfuscation/compare/v2.4.0...v3.0.0)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.1.tar.xz`
instead of the source tarball produced by GitHub.
