// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `MetricsName`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let metricsname = unimplemented!();
/// match metricsname {
///     MetricsName::All => { /* ... */ },
///     MetricsName::IncomingBytes => { /* ... */ },
///     MetricsName::IncomingRecords => { /* ... */ },
///     MetricsName::IteratorAgeMilliseconds => { /* ... */ },
///     MetricsName::OutgoingBytes => { /* ... */ },
///     MetricsName::OutgoingRecords => { /* ... */ },
///     MetricsName::ReadProvisionedThroughputExceeded => { /* ... */ },
///     MetricsName::WriteProvisionedThroughputExceeded => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `metricsname` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `MetricsName::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `MetricsName::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `MetricsName::NewFeature` is defined.
/// Specifically, when `metricsname` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `MetricsName::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum MetricsName {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    IncomingBytes,
    #[allow(missing_docs)] // documentation missing in model
    IncomingRecords,
    #[allow(missing_docs)] // documentation missing in model
    IteratorAgeMilliseconds,
    #[allow(missing_docs)] // documentation missing in model
    OutgoingBytes,
    #[allow(missing_docs)] // documentation missing in model
    OutgoingRecords,
    #[allow(missing_docs)] // documentation missing in model
    ReadProvisionedThroughputExceeded,
    #[allow(missing_docs)] // documentation missing in model
    WriteProvisionedThroughputExceeded,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for MetricsName {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => MetricsName::All,
            "IncomingBytes" => MetricsName::IncomingBytes,
            "IncomingRecords" => MetricsName::IncomingRecords,
            "IteratorAgeMilliseconds" => MetricsName::IteratorAgeMilliseconds,
            "OutgoingBytes" => MetricsName::OutgoingBytes,
            "OutgoingRecords" => MetricsName::OutgoingRecords,
            "ReadProvisionedThroughputExceeded" => MetricsName::ReadProvisionedThroughputExceeded,
            "WriteProvisionedThroughputExceeded" => MetricsName::WriteProvisionedThroughputExceeded,
            other => MetricsName::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for MetricsName {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(MetricsName::from(s))
    }
}
impl MetricsName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MetricsName::All => "ALL",
            MetricsName::IncomingBytes => "IncomingBytes",
            MetricsName::IncomingRecords => "IncomingRecords",
            MetricsName::IteratorAgeMilliseconds => "IteratorAgeMilliseconds",
            MetricsName::OutgoingBytes => "OutgoingBytes",
            MetricsName::OutgoingRecords => "OutgoingRecords",
            MetricsName::ReadProvisionedThroughputExceeded => "ReadProvisionedThroughputExceeded",
            MetricsName::WriteProvisionedThroughputExceeded => "WriteProvisionedThroughputExceeded",
            MetricsName::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "ALL",
            "IncomingBytes",
            "IncomingRecords",
            "IteratorAgeMilliseconds",
            "OutgoingBytes",
            "OutgoingRecords",
            "ReadProvisionedThroughputExceeded",
            "WriteProvisionedThroughputExceeded",
        ]
    }
}
impl ::std::convert::AsRef<str> for MetricsName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl MetricsName {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for MetricsName {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            MetricsName::All => write!(f, "ALL"),
            MetricsName::IncomingBytes => write!(f, "IncomingBytes"),
            MetricsName::IncomingRecords => write!(f, "IncomingRecords"),
            MetricsName::IteratorAgeMilliseconds => write!(f, "IteratorAgeMilliseconds"),
            MetricsName::OutgoingBytes => write!(f, "OutgoingBytes"),
            MetricsName::OutgoingRecords => write!(f, "OutgoingRecords"),
            MetricsName::ReadProvisionedThroughputExceeded => write!(f, "ReadProvisionedThroughputExceeded"),
            MetricsName::WriteProvisionedThroughputExceeded => write!(f, "WriteProvisionedThroughputExceeded"),
            MetricsName::Unknown(value) => write!(f, "{}", value),
        }
    }
}
