/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;

public class MySQLToolTableCheckSettings
extends SQLToolExecuteSettings<MySQLTableBase> {
    private String option;

    @Property(viewable=true, editable=true, updatable=true, listProvider=CheckOptionListProvider.class)
    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.option = JSONUtils.getString(config, (String)"option");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("option", this.option);
    }

    public static class CheckOptionListProvider
    implements IPropertyValueListProvider<MySQLToolTableCheckSettings> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLToolTableCheckSettings object) {
            return new String[]{"", "FOR UPGRADE", "QUICK", "FAST", "MEDIUM", "EXTENDED", "CHANGED"};
        }
    }
}

