// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

impl Format<u16> for Table1Marker {
    const FORMAT: u16 = 1;
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct Table1Marker {}

impl Table1Marker {
    pub fn format_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn heft_byte_range(&self) -> Range<usize> {
        let start = self.format_byte_range().end;
        start..start + u32::RAW_BYTE_LEN
    }

    pub fn flex_byte_range(&self) -> Range<usize> {
        let start = self.heft_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl<'a> FontRead<'a> for Table1<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        cursor.advance::<u32>();
        cursor.advance::<u16>();
        cursor.finish(Table1Marker {})
    }
}

pub type Table1<'a> = TableRef<'a, Table1Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Table1<'a> {
    pub fn format(&self) -> u16 {
        let range = self.shape.format_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn heft(&self) -> u32 {
        let range = self.shape.heft_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn flex(&self) -> u16 {
        let range = self.shape.flex_byte_range();
        self.data.read_at(range.start).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Table1<'a> {
    fn type_name(&self) -> &str {
        "Table1"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("format", self.format())),
            1usize => Some(Field::new("heft", self.heft())),
            2usize => Some(Field::new("flex", self.flex())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Table1<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

impl Format<u16> for Table2Marker {
    const FORMAT: u16 = 2;
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct Table2Marker {
    values_byte_len: usize,
}

impl Table2Marker {
    pub fn format_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn value_count_byte_range(&self) -> Range<usize> {
        let start = self.format_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn values_byte_range(&self) -> Range<usize> {
        let start = self.value_count_byte_range().end;
        start..start + self.values_byte_len
    }
}

impl<'a> FontRead<'a> for Table2<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        let value_count: u16 = cursor.read()?;
        let values_byte_len = (value_count as usize)
            .checked_mul(u16::RAW_BYTE_LEN)
            .ok_or(ReadError::OutOfBounds)?;
        cursor.advance_by(values_byte_len);
        cursor.finish(Table2Marker { values_byte_len })
    }
}

pub type Table2<'a> = TableRef<'a, Table2Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Table2<'a> {
    pub fn format(&self) -> u16 {
        let range = self.shape.format_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn value_count(&self) -> u16 {
        let range = self.shape.value_count_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn values(&self) -> &'a [BigEndian<u16>] {
        let range = self.shape.values_byte_range();
        self.data.read_array(range).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Table2<'a> {
    fn type_name(&self) -> &str {
        "Table2"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("format", self.format())),
            1usize => Some(Field::new("value_count", self.value_count())),
            2usize => Some(Field::new("values", self.values())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Table2<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

impl Format<u16> for Table3Marker {
    const FORMAT: u16 = 3;
}

#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct Table3Marker {}

impl Table3Marker {
    pub fn format_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn something_byte_range(&self) -> Range<usize> {
        let start = self.format_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl<'a> FontRead<'a> for Table3<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        cursor.advance::<u16>();
        cursor.finish(Table3Marker {})
    }
}

pub type Table3<'a> = TableRef<'a, Table3Marker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Table3<'a> {
    pub fn format(&self) -> u16 {
        let range = self.shape.format_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    pub fn something(&self) -> u16 {
        let range = self.shape.something_byte_range();
        self.data.read_at(range.start).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Table3<'a> {
    fn type_name(&self) -> &str {
        "Table3"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("format", self.format())),
            1usize => Some(Field::new("something", self.something())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Table3<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}

#[derive(Clone)]
pub enum MyTable<'a> {
    Format1(Table1<'a>),
    MyFormat22(Table2<'a>),
    Format3(Table3<'a>),
}

impl<'a> MyTable<'a> {
    ///Return the `FontData` used to resolve offsets for this table.
    pub fn offset_data(&self) -> FontData<'a> {
        match self {
            Self::Format1(item) => item.offset_data(),
            Self::MyFormat22(item) => item.offset_data(),
            Self::Format3(item) => item.offset_data(),
        }
    }

    pub fn format(&self) -> u16 {
        match self {
            Self::Format1(item) => item.format(),
            Self::MyFormat22(item) => item.format(),
            Self::Format3(item) => item.format(),
        }
    }
}

impl<'a> FontRead<'a> for MyTable<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let format: u16 = data.read_at(0usize)?;
        match format {
            Table1Marker::FORMAT => Ok(Self::Format1(FontRead::read(data)?)),
            Table2Marker::FORMAT => Ok(Self::MyFormat22(FontRead::read(data)?)),
            Table3Marker::FORMAT => Ok(Self::Format3(FontRead::read(data)?)),
            other => Err(ReadError::InvalidFormat(other.into())),
        }
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> MyTable<'a> {
    fn dyn_inner<'b>(&'b self) -> &'b dyn SomeTable<'a> {
        match self {
            Self::Format1(table) => table,
            Self::MyFormat22(table) => table,
            Self::Format3(table) => table,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
impl std::fmt::Debug for MyTable<'_> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        self.dyn_inner().fmt(f)
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for MyTable<'a> {
    fn type_name(&self) -> &str {
        self.dyn_inner().type_name()
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        self.dyn_inner().get_field(idx)
    }
}
