/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages.multidevice;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.signal.core.util.stream.LimitedInputStream;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.api.messages.multidevice.ChunkedInputStream;
import org.whispersystems.signalservice.api.messages.multidevice.DeviceGroup;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.internal.push.GroupDetails;
import org.whispersystems.signalservice.internal.util.Util;

public class DeviceGroupsInputStream
extends ChunkedInputStream {
    public DeviceGroupsInputStream(InputStream in) {
        super(in);
    }

    public DeviceGroup read() throws IOException {
        long detailsLength = this.readRawVarint32();
        if (detailsLength == -1L) {
            return null;
        }
        byte[] detailsSerialized = new byte[(int)detailsLength];
        Util.readFully(this.in, detailsSerialized);
        GroupDetails details = (GroupDetails)((Object)GroupDetails.ADAPTER.decode(detailsSerialized));
        byte[] id = details.id.toByteArray();
        Optional<String> name = Optional.ofNullable(details.name);
        List<GroupDetails.Member> members = details.members;
        Optional<SignalServiceAttachmentStream> avatar = Optional.empty();
        boolean active = details.active;
        Optional<Integer> expirationTimer = Optional.empty();
        Optional<String> color = Optional.ofNullable(details.color);
        boolean blocked = details.blocked;
        Optional<Integer> inboxPosition = Optional.empty();
        boolean archived = false;
        if (details.avatar != null && details.avatar.length != null) {
            long avatarLength = details.avatar.length.intValue();
            LimitedInputStream avatarStream = new LimitedInputStream(this.in, avatarLength);
            String avatarContentType = details.avatar.contentType;
            avatar = Optional.of(new SignalServiceAttachmentStream((InputStream)avatarStream, avatarContentType, avatarLength, Optional.empty(), false, false, false, false, null, null));
        }
        if (details.expireTimer != null && details.expireTimer > 0) {
            expirationTimer = Optional.of(details.expireTimer);
        }
        ArrayList<SignalServiceAddress> addressMembers = new ArrayList<SignalServiceAddress>(members.size());
        for (GroupDetails.Member member : members) {
            if (member.e164 != null && !member.e164.isEmpty()) {
                addressMembers.add(new SignalServiceAddress((ServiceId)ServiceId.ACI.UNKNOWN, member.e164));
                continue;
            }
            throw new IOException("Missing group member address!");
        }
        if (details.inboxPosition != null) {
            inboxPosition = Optional.of(details.inboxPosition);
        }
        if (details.archived != null) {
            archived = details.archived;
        }
        if (details.id == null) {
            if (avatar.isPresent()) {
                ((SignalServiceAttachmentStream)avatar.get()).getInputStream().readAllBytes();
            }
            throw new IOException("ID missing on group record!");
        }
        return new DeviceGroup(id, name, addressMembers, avatar, active, expirationTimer, color, blocked, inboxPosition, archived);
    }
}

