/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.signal.core.util.logging.Log;

public final class StreamUtil {
    private static final String TAG = Log.tag(StreamUtil.class);

    private StreamUtil() {
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            Log.w(TAG, e);
        }
    }

    public static long getStreamLength(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        int totalSize = 0;
        while ((read = in.read(buffer)) != -1) {
            totalSize += read;
        }
        return totalSize;
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        StreamUtil.readFully(in, buffer, buffer.length);
    }

    public static void readFully(InputStream in, byte[] buffer, int len) throws IOException {
        int offset = 0;
        while (true) {
            int read;
            if ((read = in.read(buffer, offset, len - offset)) == -1) {
                throw new EOFException("Stream ended early, offset: " + offset + " len: " + len);
            }
            if (read + offset >= len) break;
            offset += read;
        }
    }

    public static byte[] readFully(InputStream in) throws IOException {
        return StreamUtil.readFully(in, Integer.MAX_VALUE);
    }

    public static byte[] readFully(InputStream in, int maxBytes) throws IOException {
        return StreamUtil.readFully(in, maxBytes, true);
    }

    public static byte[] readFully(InputStream in, int maxBytes, boolean closeWhenDone) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int totalRead = 0;
        while ((read = in.read(buffer)) != -1) {
            bout.write(buffer, 0, read);
            if ((totalRead += read) <= maxBytes) continue;
            throw new IOException("Stream size limit exceeded");
        }
        if (closeWhenDone) {
            in.close();
        }
        return bout.toByteArray();
    }

    public static String readFullyAsString(InputStream in) throws IOException {
        return new String(StreamUtil.readFully(in));
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return StreamUtil.copy(in, out, true, true);
    }

    public static long copy(InputStream in, OutputStream out, boolean closeInputStream, boolean closeOutputStream) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        long total = 0L;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
            total += (long)read;
        }
        if (closeInputStream) {
            in.close();
        }
        out.flush();
        if (closeOutputStream) {
            out.close();
        }
        return total;
    }
}

