// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The container element for optionally specifying the default Object Lock retention settings for new objects placed in the specified bucket.</p><note>
/// <ul>
/// <li>
/// <p>The <code>DefaultRetention</code> settings require both a mode and a period.</p></li>
/// <li>
/// <p>The <code>DefaultRetention</code> period can be either <code>Days</code> or <code>Years</code> but you must select one. You cannot specify <code>Days</code> and <code>Years</code> at the same time.</p></li>
/// </ul>
/// </note>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct DefaultRetention {
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub mode: ::std::option::Option<crate::types::ObjectLockRetentionMode>,
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub days: ::std::option::Option<i32>,
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub years: ::std::option::Option<i32>,
}
impl DefaultRetention {
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub fn mode(&self) -> ::std::option::Option<&crate::types::ObjectLockRetentionMode> {
        self.mode.as_ref()
    }
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn days(&self) -> ::std::option::Option<i32> {
        self.days
    }
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn years(&self) -> ::std::option::Option<i32> {
        self.years
    }
}
impl DefaultRetention {
    /// Creates a new builder-style object to manufacture [`DefaultRetention`](crate::types::DefaultRetention).
    pub fn builder() -> crate::types::builders::DefaultRetentionBuilder {
        crate::types::builders::DefaultRetentionBuilder::default()
    }
}

/// A builder for [`DefaultRetention`](crate::types::DefaultRetention).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct DefaultRetentionBuilder {
    pub(crate) mode: ::std::option::Option<crate::types::ObjectLockRetentionMode>,
    pub(crate) days: ::std::option::Option<i32>,
    pub(crate) years: ::std::option::Option<i32>,
}
impl DefaultRetentionBuilder {
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub fn mode(mut self, input: crate::types::ObjectLockRetentionMode) -> Self {
        self.mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub fn set_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockRetentionMode>) -> Self {
        self.mode = input;
        self
    }
    /// <p>The default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Must be used with either <code>Days</code> or <code>Years</code>.</p>
    pub fn get_mode(&self) -> &::std::option::Option<crate::types::ObjectLockRetentionMode> {
        &self.mode
    }
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn days(mut self, input: i32) -> Self {
        self.days = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn set_days(mut self, input: ::std::option::Option<i32>) -> Self {
        self.days = input;
        self
    }
    /// <p>The number of days that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn get_days(&self) -> &::std::option::Option<i32> {
        &self.days
    }
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn years(mut self, input: i32) -> Self {
        self.years = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn set_years(mut self, input: ::std::option::Option<i32>) -> Self {
        self.years = input;
        self
    }
    /// <p>The number of years that you want to specify for the default retention period. Must be used with <code>Mode</code>.</p>
    pub fn get_years(&self) -> &::std::option::Option<i32> {
        &self.years
    }
    /// Consumes the builder and constructs a [`DefaultRetention`](crate::types::DefaultRetention).
    pub fn build(self) -> crate::types::DefaultRetention {
        crate::types::DefaultRetention {
            mode: self.mode,
            days: self.days,
            years: self.years,
        }
    }
}
