/* pressable.tsx generated by @compiled/babel-plugin v0.36.1 */
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "isDisabled", "type", "onClick", "interactionName", "componentName", "analyticsContext", "style", "testId", "xcss", "tabIndex"],
  _excluded2 = ["className"];
import "./pressable.compiled.css";
import * as React from 'react';
import { ax, ix } from "@compiled/react/runtime";
import { forwardRef, useCallback, useContext } from 'react';
import { cx } from '@compiled/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next';
import { isSafari } from '@atlaskit/ds-lib/device-check';
import noop from '@atlaskit/ds-lib/noop';
import InteractionContext from '@atlaskit/interaction-context';
import Focusable from './focusable';
var styles = {
  root: "_19itglyw _vchhusvi _r06hglyw _80omtlke",
  disabled: "_80om13gf"
};

/**
 * __Pressable__
 *
 * A primitive for building custom buttons.
 *
 * - [Examples](https://atlassian.design/components/primitives/pressable/examples)
 * - [Code](https://atlassian.design/components/primitives/pressable/code)
 * - [Usage](https://atlassian.design/components/primitives/pressable/usage)
 */
var Pressable = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    isDisabled = _ref.isDisabled,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$onClick = _ref.onClick,
    providedOnClick = _ref$onClick === void 0 ? noop : _ref$onClick,
    interactionName = _ref.interactionName,
    componentName = _ref.componentName,
    analyticsContext = _ref.analyticsContext,
    style = _ref.style,
    testId = _ref.testId,
    xcss = _ref.xcss,
    tabIndex = _ref.tabIndex,
    htmlAttributes = _objectWithoutProperties(_ref, _excluded);
  var interactionContext = useContext(InteractionContext);
  var handleClick = useCallback(function (e, analyticsEvent) {
    interactionContext && interactionContext.tracePress(interactionName, e.timeStamp);
    providedOnClick(e, analyticsEvent);
  }, [providedOnClick, interactionContext, interactionName]);
  var onClick = usePlatformLeafEventHandler({
    fn: handleClick,
    action: 'clicked',
    componentName: componentName || 'Pressable',
    packageName: "@atlaskit/primitives",
    packageVersion: "14.8.0",
    analyticsData: analyticsContext,
    actionSubject: 'button'
  });

  // This is to remove className from safeHtmlAttributes
  // @ts-expect-error className doesn't exist in the prop definition but we want to ensure it cannot be applied even if types are bypassed
  var _spreadClass = htmlAttributes.className,
    safeHtmlAttributes = _objectWithoutProperties(htmlAttributes, _excluded2);
  return /*#__PURE__*/React.createElement(Focusable
  // @ts-expect-error we don't allow `button` on Focusable for makers as they should use Pressable instead
  , _extends({
    as: "button"
    // Safari does not apply focus to buttons on click like other browsers, which means click events will not be fired.
    // Adding a tabIndex of 0 to the button will allow it to be focused on click.
    // This is a known issue in Safari that is meant to be "intended", see https://bugs.webkit.org/show_bug.cgi?id=22261
    ,
    tabIndex: tabIndex !== null && tabIndex !== void 0 ? tabIndex : isSafari() && !isDisabled ? 0 : undefined
    // eslint-disable-next-line @atlaskit/ui-styling-standard/enforce-style-prop -- TODO: Properly type this and allow pass-through if we can determine the type
    ,
    style: style
  }, safeHtmlAttributes, {
    type: type,
    onClick: onClick,
    disabled: isDisabled,
    xcss: cx(styles.root, isDisabled && styles.disabled, xcss),
    testId: testId,
    ref: ref
  }), children);
});
export default Pressable;