import { FC, PropsWithChildren, RefObject } from "react";
import { TNode } from "./utils";
import { TMeta, TStylingProps, TValue } from "./index";
import { MenuProps } from "@mantine/core";
export type TCascadeOptionProps<Meta extends TMeta = object> = PropsWithChildren & TStylingProps & {
    nodes: TNode<Meta>[];
    openerSelectable?: boolean;
    setFocusList: (nodes: TNode<Meta>[]) => void;
    focusedList: RefObject<TNode<Meta>[]>;
    allNodes: TNode<Meta>[];
    level: number;
    OptionComponent?: FC<{
        option: TValue;
    }>;
    option: TCascadeOption<Meta>;
    menuProps: MenuProps;
    openerMenuRef?: RefObject<HTMLDivElement>;
    onSelect: (value: Omit<TCascadeOption<Meta>, "options">[]) => void;
    index?: number;
    menuPortalTarget?: RefObject<HTMLDivElement>;
};
export type TCascadeOptionForwardRef = {
    setFocused: (val: boolean) => void;
};
export declare function CascadeOption<Meta extends Record<string, any>>({ menuProps, ...props }: TCascadeOptionProps<Meta>): import("react/jsx-runtime").JSX.Element;
export type TCascadeOption<Meta extends TMeta = object> = {
    label: string;
    value: string;
    options?: Array<TCascadeOption<Meta>>;
    meta?: Meta;
};
//# sourceMappingURL=CascadeOption.d.ts.map