/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.osgi.service.environment.EnvironmentInfo;

public class JUnitTestUtil {
    private static Boolean cachedIsJunitTestRunning = null;

    public static boolean isJunitTestRunning() {
        if (cachedIsJunitTestRunning == null) {
            try {
                if (Platform.isRunning()) {
                    AtomicBoolean result = new AtomicBoolean();
                    cachedIsJunitTestRunning = ServiceCaller.callOnce(JUnitTestUtil.class, EnvironmentInfo.class, envInfo -> {
                        String application = envInfo.getProperty("eclipse.application");
                        result.set(application != null && Set.of("org.eclipse.pde.junit.runtime.nonuithreadtestapplication", "org.eclipse.pde.junit.runtime.uitestapplication", "org.eclipse.pde.junit.runtime.coretestapplication", "org.eclipse.test.uitestapplication", "org.eclipse.test.coretestapplication", "org.eclipse.tycho.surefire.osgibooter.uitest", "org.eclipse.tycho.surefire.osgibooter.headlesstest").contains(application));
                    });
                    cachedIsJunitTestRunning = result.get();
                } else {
                    cachedIsJunitTestRunning = true;
                }
            }
            catch (Throwable t) {
                cachedIsJunitTestRunning = false;
            }
        }
        return cachedIsJunitTestRunning;
    }
}

