/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm.negotiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.policy.Policy;

public interface SymmetricKeyAlgorithmNegotiator {
    public SymmetricKeyAlgorithm negotiate(Policy.SymmetricKeyAlgorithmPolicy var1, SymmetricKeyAlgorithm var2, List<Set<SymmetricKeyAlgorithm>> var3);

    public static SymmetricKeyAlgorithmNegotiator byPopularity() {
        return new SymmetricKeyAlgorithmNegotiator(){

            @Override
            public SymmetricKeyAlgorithm negotiate(Policy.SymmetricKeyAlgorithmPolicy policy, SymmetricKeyAlgorithm override, List<Set<SymmetricKeyAlgorithm>> preferences) {
                List<SymmetricKeyAlgorithm> withSameScore;
                if (override == SymmetricKeyAlgorithm.NULL) {
                    throw new IllegalArgumentException("Algorithm override cannot be NULL (plaintext).");
                }
                if (override != null) {
                    return override;
                }
                LinkedHashMap<SymmetricKeyAlgorithm, Integer> supportWeight = new LinkedHashMap<SymmetricKeyAlgorithm, Integer>();
                for (Set<SymmetricKeyAlgorithm> set : preferences) {
                    for (SymmetricKeyAlgorithm preferred : set) {
                        if (supportWeight.containsKey((Object)preferred)) {
                            supportWeight.put(preferred, (Integer)supportWeight.get((Object)preferred) + 1);
                            continue;
                        }
                        supportWeight.put(preferred, 1);
                    }
                }
                HashMap<Integer, ArrayList<SymmetricKeyAlgorithm>> byScore = new HashMap<Integer, ArrayList<SymmetricKeyAlgorithm>>();
                for (SymmetricKeyAlgorithm algorithm : supportWeight.keySet()) {
                    int score = (Integer)supportWeight.get((Object)algorithm);
                    withSameScore = (ArrayList<SymmetricKeyAlgorithm>)byScore.get(score);
                    if (withSameScore == null) {
                        withSameScore = new ArrayList<SymmetricKeyAlgorithm>();
                        byScore.put(score, (ArrayList<SymmetricKeyAlgorithm>)withSameScore);
                    }
                    withSameScore.add(algorithm);
                }
                ArrayList arrayList = new ArrayList(byScore.keySet());
                Collections.sort(arrayList);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    int score = (Integer)arrayList.get(i);
                    withSameScore = (List)byScore.get(score);
                    SymmetricKeyAlgorithm best = policy.selectBest(withSameScore);
                    if (best == null) continue;
                    return best;
                }
                return policy.getDefaultSymmetricKeyAlgorithm();
            }
        };
    }
}

