/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledUpdate
extends ScheduledEntityAction
implements SessionImpl.Executable {
    private final Object[] fields;
    private final Object lastVersion;
    private final int[] dirtyFields;

    public ScheduledUpdate(Serializable id, Object[] fields, int[] dirtyProperties, Object lastVersion, Object instance, ClassPersister persister, SessionImplementor session) {
        super(session, id, instance, persister);
        this.fields = fields;
        this.lastVersion = lastVersion;
        this.dirtyFields = dirtyProperties;
    }

    public void execute() throws SQLException, HibernateException {
        if (this.persister.hasCache()) {
            this.persister.getCache().lock(this.id);
        }
        this.persister.update(this.id, this.fields, this.dirtyFields, this.lastVersion, this.instance, this.session);
    }

    public void afterTransactionCompletion() throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().release(this.id);
        }
    }
}

