package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUmengAppkeys invokes the airec.ListUmengAppkeys API synchronously
func (client *Client) ListUmengAppkeys(request *ListUmengAppkeysRequest) (response *ListUmengAppkeysResponse, err error) {
	response = CreateListUmengAppkeysResponse()
	err = client.DoAction(request, response)
	return
}

// ListUmengAppkeysWithChan invokes the airec.ListUmengAppkeys API asynchronously
func (client *Client) ListUmengAppkeysWithChan(request *ListUmengAppkeysRequest) (<-chan *ListUmengAppkeysResponse, <-chan error) {
	responseChan := make(chan *ListUmengAppkeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUmengAppkeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUmengAppkeysWithCallback invokes the airec.ListUmengAppkeys API asynchronously
func (client *Client) ListUmengAppkeysWithCallback(request *ListUmengAppkeysRequest, callback func(response *ListUmengAppkeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUmengAppkeysResponse
		var err error
		defer close(result)
		response, err = client.ListUmengAppkeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUmengAppkeysRequest is the request struct for api ListUmengAppkeys
type ListUmengAppkeysRequest struct {
	*requests.RoaRequest
}

// ListUmengAppkeysResponse is the response struct for api ListUmengAppkeys
type ListUmengAppkeysResponse struct {
	*responses.BaseResponse
	Code      string   `json:"code" xml:"code"`
	Message   string   `json:"message" xml:"message"`
	RequestId string   `json:"requestId" xml:"requestId"`
	Result    []Result `json:"result" xml:"result"`
}

// CreateListUmengAppkeysRequest creates a request to invoke ListUmengAppkeys API
func CreateListUmengAppkeysRequest() (request *ListUmengAppkeysRequest) {
	request = &ListUmengAppkeysRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListUmengAppkeys", "/v2/openapi/umeng/appkeys", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListUmengAppkeysResponse creates a response to parse from ListUmengAppkeys response
func CreateListUmengAppkeysResponse() (response *ListUmengAppkeysResponse) {
	response = &ListUmengAppkeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
