package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepositoryBranches invokes the codeup.ListRepositoryBranches API synchronously
func (client *Client) ListRepositoryBranches(request *ListRepositoryBranchesRequest) (response *ListRepositoryBranchesResponse, err error) {
	response = CreateListRepositoryBranchesResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepositoryBranchesWithChan invokes the codeup.ListRepositoryBranches API asynchronously
func (client *Client) ListRepositoryBranchesWithChan(request *ListRepositoryBranchesRequest) (<-chan *ListRepositoryBranchesResponse, <-chan error) {
	responseChan := make(chan *ListRepositoryBranchesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepositoryBranches(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepositoryBranchesWithCallback invokes the codeup.ListRepositoryBranches API asynchronously
func (client *Client) ListRepositoryBranchesWithCallback(request *ListRepositoryBranchesRequest, callback func(response *ListRepositoryBranchesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepositoryBranchesResponse
		var err error
		defer close(result)
		response, err = client.ListRepositoryBranches(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepositoryBranchesRequest is the request struct for api ListRepositoryBranches
type ListRepositoryBranchesRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	Search         string           `position:"Query" name:"Search"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	Page           requests.Integer `position:"Query" name:"Page"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// ListRepositoryBranchesResponse is the response struct for api ListRepositoryBranches
type ListRepositoryBranchesResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Total        int64        `json:"Total" xml:"Total"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateListRepositoryBranchesRequest creates a request to invoke ListRepositoryBranches API
func CreateListRepositoryBranchesRequest() (request *ListRepositoryBranchesRequest) {
	request = &ListRepositoryBranchesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListRepositoryBranches", "/api/v3/projects/[ProjectId]/repository/branches", "", "")
	request.Method = requests.GET
	return
}

// CreateListRepositoryBranchesResponse creates a response to parse from ListRepositoryBranches response
func CreateListRepositoryBranchesResponse() (response *ListRepositoryBranchesResponse) {
	response = &ListRepositoryBranchesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
