/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.netbeans.junit.ControlFlow;
import org.netbeans.junit.NbTestCase;
import org.netbeans.junit.internal.NbModuleLogHandler;

public final class Log
extends Handler {
    private static NbTestCase current;
    private static final StringBuffer messages;
    private static int initialMessages;
    private Reference<PrintStream> log;
    private Logger logger;

    public Log() {
    }

    private Log(Logger logger, PrintStream printStream) {
        this.log = new WeakReference<PrintStream>(printStream);
        this.logger = logger;
    }

    static Runnable internalLog() {
        return new IL(true);
    }

    public static CharSequence enable(String string, Level level) {
        IL iL = new IL(false);
        Logger logger = Logger.getLogger(string);
        if (logger.getLevel() == null || logger.getLevel().intValue() > level.intValue()) {
            logger.setLevel(level);
        }
        class MyPs
        extends PrintStream
        implements CharSequence {
            private ByteArrayOutputStream os;

            public MyPs() {
                this(new ByteArrayOutputStream());
            }

            private MyPs(ByteArrayOutputStream byteArrayOutputStream) {
                super(byteArrayOutputStream);
                this.os = byteArrayOutputStream;
            }

            @Override
            public int length() {
                return this.toString().length();
            }

            @Override
            public char charAt(int n) {
                return this.toString().charAt(n);
            }

            @Override
            public CharSequence subSequence(int n, int n2) {
                return this.toString().subSequence(n, n2);
            }

            @Override
            public String toString() {
                return this.os.toString();
            }
        }
        MyPs myPs = new MyPs();
        Log log = new Log(logger, myPs);
        log.setLevel(level);
        logger.addHandler(log);
        return myPs;
    }

    public static void controlFlow(Logger logger, Logger logger2, String string, int n) {
        ControlFlow.registerSwitches(logger, logger2, string, n);
    }

    public static void enableInstances(Logger logger, String string, Level level) {
        if (logger == null) {
            logger = Logger.getLogger("TIMER");
        }
        logger.addHandler(new InstancesHandler(string, level));
        if (logger.getLevel() == null || logger.getLevel().intValue() > level.intValue()) {
            logger.setLevel(level);
        }
    }

    public static void assertInstances(String string) {
        InstancesHandler.assertGC(string, new String[0]);
    }

    public static void assertInstances(String string, String ... stringArray) {
        InstancesHandler.assertGC(string, stringArray);
    }

    static void configure(Level level, String string, NbTestCase nbTestCase) {
        IL iL = new IL(false);
        String string2 = "handlers=" + Log.class.getName() + "\n" + string + ".level=" + level.intValue() + "\n";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        try {
            LogManager.getLogManager().readConfiguration(byteArrayInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        current = nbTestCase;
        messages.setLength(0);
        messages.append("Starting test ");
        messages.append(nbTestCase.getName());
        messages.append('\n');
        initialMessages = messages.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrintStream getLog() {
        if (this.log != null) {
            PrintStream printStream = this.log.get();
            if (printStream == null) {
                this.setLevel(Level.OFF);
                this.logger.removeHandler(this);
            }
            return printStream;
        }
        NbTestCase nbTestCase = current;
        Runnable runnable = Log.internalLog();
        try {
            PrintStream printStream = nbTestCase == null ? System.err : nbTestCase.getLog();
            return printStream;
        }
        finally {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        if (IL.isInternalLog()) {
            return;
        }
        Runnable runnable = Log.internalLog();
        try {
            StringBuffer stringBuffer = NbModuleLogHandler.toString(logRecord);
            PrintStream printStream = this.getLog();
            if (printStream != null) {
                try {
                    printStream.println(stringBuffer.toString());
                }
                catch (LinkageError linkageError) {
                    // empty catch block
                }
            }
            if (messages.length() + stringBuffer.length() > 20000) {
                if (stringBuffer.length() > 20000) {
                    messages.setLength(0);
                    stringBuffer.delete(0, stringBuffer.length() - 20000);
                } else {
                    messages.setLength(20000 - stringBuffer.length());
                }
            }
            messages.append(stringBuffer.toString());
        }
        finally {
            runnable.run();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        Logger logger = this.logger;
        if (this.getLevel() != Level.OFF && logger != null) {
            logger.addHandler(this);
        }
    }

    static String normalizedMessages(String string) {
        if (messages.length() == initialMessages) {
            return null;
        }
        return NbModuleLogHandler.normalize(messages, string);
    }

    static Throwable wrapWithMessages(Throwable throwable, String string) {
        String string2 = Log.normalizedMessages(string);
        if (string2 == null) {
            return throwable;
        }
        return Log.wrapWithAddendum(throwable, "Log:\n" + string2, true);
    }

    static Throwable wrapWithAddendum(Throwable throwable, String string, boolean bl) {
        if (throwable instanceof AssertionFailedError) {
            AssertionFailedError assertionFailedError = new AssertionFailedError(Log.combineMessages(throwable, string, bl));
            if (throwable.getCause() != null) {
                assertionFailedError.initCause(throwable.getCause());
            }
            assertionFailedError.setStackTrace(throwable.getStackTrace());
            return assertionFailedError;
        }
        if (throwable instanceof AssertionError) {
            AssertionError assertionError = new AssertionError((Object)Log.combineMessages(throwable, string, bl));
            if (throwable.getCause() != null) {
                ((Throwable)((Object)assertionError)).initCause(throwable.getCause());
            }
            ((Throwable)((Object)assertionError)).setStackTrace(throwable.getStackTrace());
            return assertionError;
        }
        if (throwable instanceof IOException) {
            IOException iOException = new IOException(Log.combineMessages(throwable, string, bl));
            if (throwable.getCause() != null) {
                iOException.initCause(throwable.getCause());
            }
            iOException.setStackTrace(throwable.getStackTrace());
            return iOException;
        }
        if (throwable instanceof Exception) {
            return new InvocationTargetException(throwable, Log.combineMessages(throwable, string, bl));
        }
        return throwable;
    }

    private static String combineMessages(Throwable throwable, String string, boolean bl) {
        String string2 = throwable.getMessage();
        return string2 == null || string2.equals("null") ? string : (bl ? string2 + " " + string : string + " " + string2);
    }

    static {
        messages = new StringBuffer();
    }

    private static class IL
    implements Runnable {
        private static ThreadLocal<Boolean> INTERNAL_LOG = new ThreadLocal();
        private final Boolean prev = INTERNAL_LOG.get();

        public IL(boolean bl) {
            INTERNAL_LOG.set(bl);
        }

        @Override
        public void run() {
            INTERNAL_LOG.set(this.prev);
        }

        public static boolean isInternalLog() {
            return Boolean.TRUE.equals(INTERNAL_LOG.get());
        }
    }

    private static class InstancesHandler
    extends Handler {
        static final Map<Object, String> instances = Collections.synchronizedMap(new WeakHashMap());
        static int cnt;
        private final String msg;

        public InstancesHandler(String string, Level level) {
            this.setLevel(level);
            this.msg = string;
        }

        @Override
        public void publish(LogRecord logRecord) {
            Object[] objectArray = logRecord.getParameters();
            if (objectArray == null) {
                return;
            }
            if (this.msg != null && !this.msg.equals(logRecord.getMessage())) {
                return;
            }
            ++cnt;
            for (Object object : objectArray) {
                instances.put(object, logRecord.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void assertGC(String string, String ... stringArray) {
            Object object;
            AssertionFailedError assertionFailedError = null;
            ArrayList<WeakReference<Object>> arrayList = new ArrayList<WeakReference<Object>>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = 0;
            HashSet<String> hashSet = stringArray == null || stringArray.length == 0 ? null : new HashSet<String>(Arrays.asList(stringArray));
            Map<Object, String> map = instances;
            synchronized (map) {
                object = instances.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<Object, String> entry = object.next();
                    if (hashSet != null && !hashSet.contains(entry.getValue())) continue;
                    arrayList.add(new WeakReference<Object>(entry.getKey()));
                    arrayList2.add(entry.getValue());
                    object.remove();
                    ++n;
                }
            }
            if (n == 0) {
                TestCase.fail((String)"No instance of this type reported");
            }
            for (int i = 0; i < n; ++i) {
                object = (Reference)arrayList.get(i);
                try {
                    NbTestCase.assertGC(string + " " + (String)arrayList2.get(i), object);
                    continue;
                }
                catch (AssertionFailedError assertionFailedError2) {
                    if (assertionFailedError == null) {
                        assertionFailedError = assertionFailedError2;
                        continue;
                    }
                    Throwable throwable = assertionFailedError;
                    while (throwable.getCause() != null) {
                        throwable = throwable.getCause();
                    }
                    throwable.initCause(assertionFailedError2);
                }
            }
            if (assertionFailedError != null) {
                throw assertionFailedError;
            }
        }
    }
}

