/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.helper.ExtendedUri;

public class Feature {
    private String id;
    private long offset;
    private ExtendedUri iconUri;
    private Map<Locale, String> displayNames;
    private Map<Locale, String> descriptions;

    public Feature(String id, long offset, ExtendedUri iconUri, Map<Locale, String> displayNames, Map<Locale, String> descriptions) {
        this.id = id;
        this.offset = offset;
        this.iconUri = iconUri;
        this.displayNames = new HashMap<Locale, String>();
        this.displayNames.putAll(displayNames);
        this.descriptions = new HashMap<Locale, String>();
        this.descriptions.putAll(descriptions);
    }

    public String getId() {
        return this.id;
    }

    public long getOffset() {
        return this.offset;
    }

    public ExtendedUri getIconUri() {
        return this.iconUri;
    }

    public String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        return StringUtils.getLocalizedString(this.displayNames, locale);
    }

    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    public String getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public String getDescription(Locale locale) {
        return StringUtils.getLocalizedString(this.descriptions, locale);
    }

    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    public boolean equals(Feature feature) {
        return feature != null ? this.id.equals(feature.getId()) : false;
    }
}

