/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteFileList
extends Task {
    private String dir;
    private String output;
    private String mask;

    private void check(String s, String desc) throws BuildException {
        if (s == null) {
            throw new BuildException("Error! Parameter '" + desc + "' can`t be null!!");
        }
    }

    private void write(StringBuilder sb, String s) {
        sb.append(s);
        sb.append(System.getProperty("line.separator"));
    }

    private void listFile(File parent, File f, StringBuilder sb) throws IOException {
        String path = f.getPath();
        String parentPath = parent.getPath();
        path = path.substring(parentPath.length());
        if ((path = path.replaceAll("\\\\", "/")).length() > 0) {
            path = path.substring(1);
        }
        if (f.isFile()) {
            if (path.length() > 0 && path.matches(this.mask)) {
                this.write(sb, path);
            }
        } else if (f.isDirectory()) {
            File[] files;
            File[] dirs;
            if (path.length() > 0 && (path = path + "/").matches(this.mask)) {
                this.write(sb, path);
            }
            for (File file : dirs = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                this.listFile(parent, file, sb);
            }
            for (File file : files = f.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && !pathname.isDirectory();
                }
            })) {
                this.listFile(parent, file, sb);
            }
        }
    }

    public void execute() throws BuildException {
        File outFile;
        this.check(this.dir, "starting directory");
        this.check(this.output, "output file");
        this.check(this.mask, "file mask");
        File root = new File(this.dir);
        if (!root.equals(root.getAbsoluteFile())) {
            root = new File(this.getProject().getBaseDir(), this.dir);
        }
        if (!(outFile = new File(this.output)).equals(outFile.getAbsoluteFile())) {
            outFile = new File(this.getProject().getBaseDir(), this.output);
        }
        FileOutputStream fos = null;
        this.log("Root directory : " + root);
        this.log("Output file : " + outFile);
        this.log("Mask  : " + this.mask);
        try {
            StringBuilder sb = new StringBuilder();
            this.listFile(root, root, sb);
            fos = new FileOutputStream(outFile);
            fos.write(sb.toString().getBytes());
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }
}

