﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/config/model/ResourceIdentifier.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ConfigService {
namespace Model {

ResourceIdentifier::ResourceIdentifier(JsonView jsonValue) { *this = jsonValue; }

ResourceIdentifier& ResourceIdentifier::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("resourceType")) {
    m_resourceType = ResourceTypeMapper::GetResourceTypeForName(jsonValue.GetString("resourceType"));
    m_resourceTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("resourceId")) {
    m_resourceId = jsonValue.GetString("resourceId");
    m_resourceIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("resourceName")) {
    m_resourceName = jsonValue.GetString("resourceName");
    m_resourceNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("resourceDeletionTime")) {
    m_resourceDeletionTime = jsonValue.GetDouble("resourceDeletionTime");
    m_resourceDeletionTimeHasBeenSet = true;
  }
  return *this;
}

JsonValue ResourceIdentifier::Jsonize() const {
  JsonValue payload;

  if (m_resourceTypeHasBeenSet) {
    payload.WithString("resourceType", ResourceTypeMapper::GetNameForResourceType(m_resourceType));
  }

  if (m_resourceIdHasBeenSet) {
    payload.WithString("resourceId", m_resourceId);
  }

  if (m_resourceNameHasBeenSet) {
    payload.WithString("resourceName", m_resourceName);
  }

  if (m_resourceDeletionTimeHasBeenSet) {
    payload.WithDouble("resourceDeletionTime", m_resourceDeletionTime.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
