/* audispd-pconfig.h -- 
 * Copyright 2007 Red Hat Inc., Durham, North Carolina.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *   Steve Grubb <sgrubb@redhat.com>
 * 
 */

#ifndef AUDISPD_PCONFIG_H
#define AUDISPD_PCONFIG_H

#include "libaudit.h"
#define MAX_PLUGIN_ARGS 2

typedef enum { A_NO, A_YES } active_t;
typedef enum { D_UNSET, D_IN, D_OUT } direction_t;
typedef enum { S_ONDEMAND, S_BUILTIN, S_ALWAYS } service_t;
typedef enum { F_BINARY, F_STRING } format_t;

typedef struct plugin_conf
{
	active_t active;
	direction_t direction;
	const char *path;
	service_t type;
	char *args[MAX_PLUGIN_ARGS+2];
	format_t format;
} plugin_conf_t;

void clear_pconfig(plugin_conf_t *config);
int  load_pconfig(plugin_conf_t *config, const char *file);
void free_pconfig(plugin_conf_t *config);

#endif

