/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _FADEDESKTOP_OPTIONS_INTERNAL
#include "fadedesktop_options.h"

static int displayPrivateIndex;

static CompMetadata fadedesktopOptionsMetadata;

static CompPluginVTable *fadedesktopPluginVTable = NULL;
CompPluginVTable fadedesktopOptionsVTable;

#define GET_FADEDESKTOP_OPTIONS_DISPLAY(d) \
        ((FadedesktopOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define FADEDESKTOP_OPTIONS_DISPLAY(d) \
        FadedesktopOptionsDisplay *od = GET_FADEDESKTOP_OPTIONS_DISPLAY (d)

#define GET_FADEDESKTOP_OPTIONS_SCREEN(s, od) \
        ((FadedesktopOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define FADEDESKTOP_OPTIONS_SCREEN(s) \
        FadedesktopOptionsScreen *os = GET_FADEDESKTOP_OPTIONS_SCREEN (s, GET_FADEDESKTOP_OPTIONS_DISPLAY (s->display))

typedef struct _FadedesktopOptionsDisplay
{
    int screenPrivateIndex;

} FadedesktopOptionsDisplay;

typedef struct _FadedesktopOptionsScreen
{
    CompOption opt[FadedesktopScreenOptionNum];
    fadedesktopScreenOptionChangeNotifyProc notify[FadedesktopScreenOptionNum];
} FadedesktopOptionsScreen;

int fadedesktopGetFadetime (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return os->opt[FadedesktopScreenOptionFadetime].value.i;
}

CompOption * fadedesktopGetFadetimeOption (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionFadetime];
}

void fadedesktopSetFadetimeNotify (CompScreen *s, fadedesktopScreenOptionChangeNotifyProc notify)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    os->notify[FadedesktopScreenOptionFadetime] = notify;
}

CompMatch * fadedesktopGetWindowMatch (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionWindowMatch].value.match;
}

CompOption * fadedesktopGetWindowMatchOption (CompScreen *s)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[FadedesktopScreenOptionWindowMatch];
}

void fadedesktopSetWindowMatchNotify (CompScreen *s, fadedesktopScreenOptionChangeNotifyProc notify)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    os->notify[FadedesktopScreenOptionWindowMatch] = notify;
}

CompOption * fadedesktopGetScreenOption (CompScreen *s, FadedesktopScreenOptions num)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo fadedesktopOptionsScreenOptionInfo[] = {
    { "fadetime", "int", "<min>1</min><max>5000</max>", 0, 0 },
    { "window_match", "match", 0, 0, 0 },
};

static Bool fadedesktopOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, FadedesktopScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FadedesktopScreenOptionFadetime:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FadedesktopScreenOptionFadetime])
                (*os->notify[FadedesktopScreenOptionFadetime]) (s, o, FadedesktopScreenOptionFadetime);
            return TRUE;
        }
        break;
     case FadedesktopScreenOptionWindowMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FadedesktopScreenOptionWindowMatch])
                (*os->notify[FadedesktopScreenOptionWindowMatch]) (s, o, FadedesktopScreenOptionWindowMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * fadedesktopOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    FADEDESKTOP_OPTIONS_SCREEN(s);
    *count = FadedesktopScreenOptionNum;
    return os->opt;
}

static Bool fadedesktopOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    FadedesktopOptionsScreen *os;
    
    FADEDESKTOP_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(FadedesktopOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &fadedesktopOptionsMetadata, fadedesktopOptionsScreenOptionInfo, os->opt, FadedesktopScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->initScreen)
        return fadedesktopPluginVTable->initScreen (p, s);
    return TRUE;
}

static void fadedesktopOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->finiScreen)
        return fadedesktopPluginVTable->finiScreen (p, s);

    FADEDESKTOP_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, FadedesktopScreenOptionNum);

    free (os);
}

static Bool fadedesktopOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    FadedesktopOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(FadedesktopOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

        if (fadedesktopPluginVTable && fadedesktopPluginVTable->initDisplay)
        return fadedesktopPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void fadedesktopOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->finiDisplay)
        return fadedesktopPluginVTable->finiDisplay (p, d);

    FADEDESKTOP_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool fadedesktopOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&fadedesktopOptionsMetadata, "fadedesktop",0, 0, fadedesktopOptionsScreenOptionInfo, FadedesktopScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&fadedesktopOptionsMetadata, "fadedesktop");
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->init)
        return fadedesktopPluginVTable->init (p);
    return TRUE;
}

static void fadedesktopOptionsFini (CompPlugin *p)
{
    if (fadedesktopPluginVTable && fadedesktopPluginVTable->fini)
        return fadedesktopPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&fadedesktopOptionsMetadata);
}

static CompMetadata *
fadedesktopOptionsGetMetadata (CompPlugin *plugin)
{
    return &fadedesktopOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!fadedesktopPluginVTable)
    {
        fadedesktopPluginVTable = fadedesktopOptionsGetCompPluginInfo ();
        memcpy(&fadedesktopOptionsVTable, fadedesktopPluginVTable, sizeof(CompPluginVTable));
        fadedesktopOptionsVTable.getMetadata = fadedesktopOptionsGetMetadata;
        fadedesktopOptionsVTable.init = fadedesktopOptionsInit;
        fadedesktopOptionsVTable.fini = fadedesktopOptionsFini;
        fadedesktopOptionsVTable.initDisplay = fadedesktopOptionsInitDisplay;
        fadedesktopOptionsVTable.finiDisplay = fadedesktopOptionsFiniDisplay;
        fadedesktopOptionsVTable.initScreen = fadedesktopOptionsInitScreen;
        fadedesktopOptionsVTable.finiScreen = fadedesktopOptionsFiniScreen;
        fadedesktopOptionsVTable.getScreenOptions = fadedesktopOptionsGetScreenOptions;
	fadedesktopOptionsVTable.setScreenOption = fadedesktopOptionsSetScreenOption;
	
    }
    return &fadedesktopOptionsVTable;
}

