/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _FIREPAINT_OPTIONS_INTERNAL
#include "firepaint_options.h"

static int displayPrivateIndex;

static CompMetadata firepaintOptionsMetadata;

static CompPluginVTable *firepaintPluginVTable = NULL;
CompPluginVTable firepaintOptionsVTable;

#define GET_FIREPAINT_OPTIONS_DISPLAY(d) \
        ((FirepaintOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define FIREPAINT_OPTIONS_DISPLAY(d) \
        FirepaintOptionsDisplay *od = GET_FIREPAINT_OPTIONS_DISPLAY (d)

#define GET_FIREPAINT_OPTIONS_SCREEN(s, od) \
        ((FirepaintOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define FIREPAINT_OPTIONS_SCREEN(s) \
        FirepaintOptionsScreen *os = GET_FIREPAINT_OPTIONS_SCREEN (s, GET_FIREPAINT_OPTIONS_DISPLAY (s->display))

typedef struct _FirepaintOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[FirepaintDisplayOptionNum];
    firepaintDisplayOptionChangeNotifyProc notify[FirepaintDisplayOptionNum];
} FirepaintOptionsDisplay;

typedef struct _FirepaintOptionsScreen
{
    CompOption opt[FirepaintScreenOptionNum];
    firepaintScreenOptionChangeNotifyProc notify[FirepaintScreenOptionNum];
} FirepaintOptionsScreen;

CompAction * firepaintGetInitiate (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiate].value.action;
}

void firepaintSetInitiateInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiate].value.action.initiate = init;
}

void firepaintSetInitiateTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionInitiate].value.action.terminate = term;
}

CompOption * firepaintGetInitiateOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionInitiate];
}

void firepaintSetInitiateNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionInitiate] = notify;
}

CompAction * firepaintGetClear (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClear].value.action;
}

void firepaintSetClearInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClear].value.action.initiate = init;
}

void firepaintSetClearTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->opt[FirepaintDisplayOptionClear].value.action.terminate = term;
}

CompOption * firepaintGetClearOption (CompDisplay *d)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[FirepaintDisplayOptionClear];
}

void firepaintSetClearNotify (CompDisplay *d, firepaintDisplayOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    od->notify[FirepaintDisplayOptionClear] = notify;
}

int firepaintGetNumParticles (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionNumParticles].value.i;
}

CompOption * firepaintGetNumParticlesOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionNumParticles];
}

void firepaintSetNumParticlesNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionNumParticles] = notify;
}

float firepaintGetFireSize (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireSize].value.f;
}

CompOption * firepaintGetFireSizeOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireSize];
}

void firepaintSetFireSizeNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireSize] = notify;
}

float firepaintGetFireSlowdown (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireSlowdown].value.f;
}

CompOption * firepaintGetFireSlowdownOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireSlowdown];
}

void firepaintSetFireSlowdownNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireSlowdown] = notify;
}

float firepaintGetFireLife (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireLife].value.f;
}

CompOption * firepaintGetFireLifeOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireLife];
}

void firepaintSetFireLifeNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireLife] = notify;
}

unsigned short * firepaintGetFireColor (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c;
}

unsigned short firepaintGetFireColorRed (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[0];
}

unsigned short firepaintGetFireColorGreen (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[1];
}

unsigned short firepaintGetFireColorBlue (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[2];
}

unsigned short firepaintGetFireColorAlpha (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireColor].value.c[3];
}

CompOption * firepaintGetFireColorOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireColor];
}

void firepaintSetFireColorNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireColor] = notify;
}

Bool firepaintGetFireMystical (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionFireMystical].value.b;
}

CompOption * firepaintGetFireMysticalOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionFireMystical];
}

void firepaintSetFireMysticalNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionFireMystical] = notify;
}

int firepaintGetBgBrightness (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return os->opt[FirepaintScreenOptionBgBrightness].value.i;
}

CompOption * firepaintGetBgBrightnessOption (CompScreen *s)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[FirepaintScreenOptionBgBrightness];
}

void firepaintSetBgBrightnessNotify (CompScreen *s, firepaintScreenOptionChangeNotifyProc notify)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    os->notify[FirepaintScreenOptionBgBrightness] = notify;
}

CompOption * firepaintGetDisplayOption (CompDisplay *d, FirepaintDisplayOptions num)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * firepaintGetScreenOption (CompScreen *s, FirepaintScreenOptions num)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo firepaintOptionsDisplayOptionInfo[] = {
    { "initiate", "action", 0, 0, 0 },
    { "clear", "action", 0, 0, 0 },
};

static Bool firepaintOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, FirepaintDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FirepaintDisplayOptionInitiate:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionInitiate])
                (*od->notify[FirepaintDisplayOptionInitiate]) (d, o, FirepaintDisplayOptionInitiate);
            return TRUE;
        }
        break;
     case FirepaintDisplayOptionClear:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[FirepaintDisplayOptionClear])
                (*od->notify[FirepaintDisplayOptionClear]) (d, o, FirepaintDisplayOptionClear);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * firepaintOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    FIREPAINT_OPTIONS_DISPLAY(d);
    *count = FirepaintDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo firepaintOptionsScreenOptionInfo[] = {
    { "num_Particles", "int", "<min>100</min><max>20000</max>", 0, 0 },
    { "fire_size", "float", "<min>0.1</min><max>40</max>", 0, 0 },
    { "fire_slowdown", "float", "<min>0.1</min><max>10</max>", 0, 0 },
    { "fire_life", "float", "<min>0.1</min><max>0.95</max>", 0, 0 },
    { "fire_color", "color", 0, 0, 0 },
    { "fire_mystical", "bool", 0, 0, 0 },
    { "bg_brightness", "int", "<min>0</min><max>100</max>", 0, 0 },
};

static Bool firepaintOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, FirepaintScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case FirepaintScreenOptionNumParticles:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionNumParticles])
                (*os->notify[FirepaintScreenOptionNumParticles]) (s, o, FirepaintScreenOptionNumParticles);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireSize])
                (*os->notify[FirepaintScreenOptionFireSize]) (s, o, FirepaintScreenOptionFireSize);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireSlowdown:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireSlowdown])
                (*os->notify[FirepaintScreenOptionFireSlowdown]) (s, o, FirepaintScreenOptionFireSlowdown);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireLife:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireLife])
                (*os->notify[FirepaintScreenOptionFireLife]) (s, o, FirepaintScreenOptionFireLife);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireColor])
                (*os->notify[FirepaintScreenOptionFireColor]) (s, o, FirepaintScreenOptionFireColor);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionFireMystical:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionFireMystical])
                (*os->notify[FirepaintScreenOptionFireMystical]) (s, o, FirepaintScreenOptionFireMystical);
            return TRUE;
        }
        break;
     case FirepaintScreenOptionBgBrightness:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[FirepaintScreenOptionBgBrightness])
                (*os->notify[FirepaintScreenOptionBgBrightness]) (s, o, FirepaintScreenOptionBgBrightness);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * firepaintOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    FIREPAINT_OPTIONS_SCREEN(s);
    *count = FirepaintScreenOptionNum;
    return os->opt;
}

static Bool firepaintOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    FirepaintOptionsScreen *os;
    
    FIREPAINT_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(FirepaintOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &firepaintOptionsMetadata, firepaintOptionsScreenOptionInfo, os->opt, FirepaintScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (firepaintPluginVTable && firepaintPluginVTable->initScreen)
        return firepaintPluginVTable->initScreen (p, s);
    return TRUE;
}

static void firepaintOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (firepaintPluginVTable && firepaintPluginVTable->finiScreen)
        return firepaintPluginVTable->finiScreen (p, s);

    FIREPAINT_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, FirepaintScreenOptionNum);

    free (os);
}

static Bool firepaintOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    FirepaintOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(FirepaintOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &firepaintOptionsMetadata, firepaintOptionsDisplayOptionInfo, od->opt, FirepaintDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (firepaintPluginVTable && firepaintPluginVTable->initDisplay)
        return firepaintPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void firepaintOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (firepaintPluginVTable && firepaintPluginVTable->finiDisplay)
        return firepaintPluginVTable->finiDisplay (p, d);

    FIREPAINT_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, FirepaintDisplayOptionNum);

    free (od);
}

static Bool firepaintOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&firepaintOptionsMetadata, "firepaint",firepaintOptionsDisplayOptionInfo, FirepaintDisplayOptionNum, firepaintOptionsScreenOptionInfo, FirepaintScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&firepaintOptionsMetadata, "firepaint");
    if (firepaintPluginVTable && firepaintPluginVTable->init)
        return firepaintPluginVTable->init (p);
    return TRUE;
}

static void firepaintOptionsFini (CompPlugin *p)
{
    if (firepaintPluginVTable && firepaintPluginVTable->fini)
        return firepaintPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&firepaintOptionsMetadata);
}

static CompMetadata *
firepaintOptionsGetMetadata (CompPlugin *plugin)
{
    return &firepaintOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!firepaintPluginVTable)
    {
        firepaintPluginVTable = firepaintOptionsGetCompPluginInfo ();
        memcpy(&firepaintOptionsVTable, firepaintPluginVTable, sizeof(CompPluginVTable));
        firepaintOptionsVTable.getMetadata = firepaintOptionsGetMetadata;
        firepaintOptionsVTable.init = firepaintOptionsInit;
        firepaintOptionsVTable.fini = firepaintOptionsFini;
        firepaintOptionsVTable.initDisplay = firepaintOptionsInitDisplay;
        firepaintOptionsVTable.finiDisplay = firepaintOptionsFiniDisplay;
        firepaintOptionsVTable.initScreen = firepaintOptionsInitScreen;
        firepaintOptionsVTable.finiScreen = firepaintOptionsFiniScreen;
        firepaintOptionsVTable.getDisplayOptions = firepaintOptionsGetDisplayOptions;
	firepaintOptionsVTable.setDisplayOption = firepaintOptionsSetDisplayOption;
	firepaintOptionsVTable.getScreenOptions = firepaintOptionsGetScreenOptions;
	firepaintOptionsVTable.setScreenOption = firepaintOptionsSetScreenOption;
	
    }
    return &firepaintOptionsVTable;
}

