/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _SCALEFILTER_OPTIONS_INTERNAL
#include "scalefilter_options.h"

static int displayPrivateIndex;

static CompMetadata scalefilterOptionsMetadata;

static CompPluginVTable *scalefilterPluginVTable = NULL;
CompPluginVTable scalefilterOptionsVTable;

#define GET_SCALEFILTER_OPTIONS_DISPLAY(d) \
        ((ScalefilterOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define SCALEFILTER_OPTIONS_DISPLAY(d) \
        ScalefilterOptionsDisplay *od = GET_SCALEFILTER_OPTIONS_DISPLAY (d)

#define GET_SCALEFILTER_OPTIONS_SCREEN(s, od) \
        ((ScalefilterOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define SCALEFILTER_OPTIONS_SCREEN(s) \
        ScalefilterOptionsScreen *os = GET_SCALEFILTER_OPTIONS_SCREEN (s, GET_SCALEFILTER_OPTIONS_DISPLAY (s->display))

typedef struct _ScalefilterOptionsDisplay
{
    int screenPrivateIndex;

} ScalefilterOptionsDisplay;

typedef struct _ScalefilterOptionsScreen
{
    CompOption opt[ScalefilterScreenOptionNum];
    scalefilterScreenOptionChangeNotifyProc notify[ScalefilterScreenOptionNum];
} ScalefilterOptionsScreen;

int scalefilterGetTimeout (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionTimeout].value.i;
}

CompOption * scalefilterGetTimeoutOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionTimeout];
}

void scalefilterSetTimeoutNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionTimeout] = notify;
}

Bool scalefilterGetFilterCaseInsensitive (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFilterCaseInsensitive].value.b;
}

CompOption * scalefilterGetFilterCaseInsensitiveOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFilterCaseInsensitive];
}

void scalefilterSetFilterCaseInsensitiveNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFilterCaseInsensitive] = notify;
}

Bool scalefilterGetFilterDisplay (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFilterDisplay].value.b;
}

CompOption * scalefilterGetFilterDisplayOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFilterDisplay];
}

void scalefilterSetFilterDisplayNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFilterDisplay] = notify;
}

Bool scalefilterGetFontBold (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontBold].value.b;
}

CompOption * scalefilterGetFontBoldOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontBold];
}

void scalefilterSetFontBoldNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontBold] = notify;
}

int scalefilterGetFontSize (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontSize].value.i;
}

CompOption * scalefilterGetFontSizeOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontSize];
}

void scalefilterSetFontSizeNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontSize] = notify;
}

int scalefilterGetBorderSize (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBorderSize].value.i;
}

CompOption * scalefilterGetBorderSizeOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionBorderSize];
}

void scalefilterSetBorderSizeNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionBorderSize] = notify;
}

unsigned short * scalefilterGetFontColor (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c;
}

unsigned short scalefilterGetFontColorRed (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[0];
}

unsigned short scalefilterGetFontColorGreen (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[1];
}

unsigned short scalefilterGetFontColorBlue (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[2];
}

unsigned short scalefilterGetFontColorAlpha (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionFontColor].value.c[3];
}

CompOption * scalefilterGetFontColorOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionFontColor];
}

void scalefilterSetFontColorNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionFontColor] = notify;
}

unsigned short * scalefilterGetBackColor (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c;
}

unsigned short scalefilterGetBackColorRed (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[0];
}

unsigned short scalefilterGetBackColorGreen (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[1];
}

unsigned short scalefilterGetBackColorBlue (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[2];
}

unsigned short scalefilterGetBackColorAlpha (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return os->opt[ScalefilterScreenOptionBackColor].value.c[3];
}

CompOption * scalefilterGetBackColorOption (CompScreen *s)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[ScalefilterScreenOptionBackColor];
}

void scalefilterSetBackColorNotify (CompScreen *s, scalefilterScreenOptionChangeNotifyProc notify)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    os->notify[ScalefilterScreenOptionBackColor] = notify;
}

CompOption * scalefilterGetScreenOption (CompScreen *s, ScalefilterScreenOptions num)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo scalefilterOptionsScreenOptionInfo[] = {
    { "timeout", "int", "<min>0</min><max>10000</max>", 0, 0 },
    { "filter_case_insensitive", "bool", 0, 0, 0 },
    { "filter_display", "bool", 0, 0, 0 },
    { "font_bold", "bool", 0, 0, 0 },
    { "font_size", "int", "<min>6</min><max>48</max>", 0, 0 },
    { "border_size", "int", "<min>1</min><max>20</max>", 0, 0 },
    { "font_color", "color", 0, 0, 0 },
    { "back_color", "color", 0, 0, 0 },
};

static Bool scalefilterOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, ScalefilterScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case ScalefilterScreenOptionTimeout:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionTimeout])
                (*os->notify[ScalefilterScreenOptionTimeout]) (s, o, ScalefilterScreenOptionTimeout);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFilterCaseInsensitive:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFilterCaseInsensitive])
                (*os->notify[ScalefilterScreenOptionFilterCaseInsensitive]) (s, o, ScalefilterScreenOptionFilterCaseInsensitive);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFilterDisplay:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFilterDisplay])
                (*os->notify[ScalefilterScreenOptionFilterDisplay]) (s, o, ScalefilterScreenOptionFilterDisplay);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontBold:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontBold])
                (*os->notify[ScalefilterScreenOptionFontBold]) (s, o, ScalefilterScreenOptionFontBold);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontSize])
                (*os->notify[ScalefilterScreenOptionFontSize]) (s, o, ScalefilterScreenOptionFontSize);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionBorderSize:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionBorderSize])
                (*os->notify[ScalefilterScreenOptionBorderSize]) (s, o, ScalefilterScreenOptionBorderSize);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionFontColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionFontColor])
                (*os->notify[ScalefilterScreenOptionFontColor]) (s, o, ScalefilterScreenOptionFontColor);
            return TRUE;
        }
        break;
     case ScalefilterScreenOptionBackColor:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[ScalefilterScreenOptionBackColor])
                (*os->notify[ScalefilterScreenOptionBackColor]) (s, o, ScalefilterScreenOptionBackColor);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * scalefilterOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    SCALEFILTER_OPTIONS_SCREEN(s);
    *count = ScalefilterScreenOptionNum;
    return os->opt;
}

static Bool scalefilterOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    ScalefilterOptionsScreen *os;
    
    SCALEFILTER_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(ScalefilterOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &scalefilterOptionsMetadata, scalefilterOptionsScreenOptionInfo, os->opt, ScalefilterScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (scalefilterPluginVTable && scalefilterPluginVTable->initScreen)
        return scalefilterPluginVTable->initScreen (p, s);
    return TRUE;
}

static void scalefilterOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (scalefilterPluginVTable && scalefilterPluginVTable->finiScreen)
        return scalefilterPluginVTable->finiScreen (p, s);

    SCALEFILTER_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, ScalefilterScreenOptionNum);

    free (os);
}

static Bool scalefilterOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    ScalefilterOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(ScalefilterOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

        if (scalefilterPluginVTable && scalefilterPluginVTable->initDisplay)
        return scalefilterPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void scalefilterOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (scalefilterPluginVTable && scalefilterPluginVTable->finiDisplay)
        return scalefilterPluginVTable->finiDisplay (p, d);

    SCALEFILTER_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);
    free (od);
}

static Bool scalefilterOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&scalefilterOptionsMetadata, "scalefilter",0, 0, scalefilterOptionsScreenOptionInfo, ScalefilterScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&scalefilterOptionsMetadata, "scalefilter");
    if (scalefilterPluginVTable && scalefilterPluginVTable->init)
        return scalefilterPluginVTable->init (p);
    return TRUE;
}

static void scalefilterOptionsFini (CompPlugin *p)
{
    if (scalefilterPluginVTable && scalefilterPluginVTable->fini)
        return scalefilterPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&scalefilterOptionsMetadata);
}

static CompMetadata *
scalefilterOptionsGetMetadata (CompPlugin *plugin)
{
    return &scalefilterOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!scalefilterPluginVTable)
    {
        scalefilterPluginVTable = scalefilterOptionsGetCompPluginInfo ();
        memcpy(&scalefilterOptionsVTable, scalefilterPluginVTable, sizeof(CompPluginVTable));
        scalefilterOptionsVTable.getMetadata = scalefilterOptionsGetMetadata;
        scalefilterOptionsVTable.init = scalefilterOptionsInit;
        scalefilterOptionsVTable.fini = scalefilterOptionsFini;
        scalefilterOptionsVTable.initDisplay = scalefilterOptionsInitDisplay;
        scalefilterOptionsVTable.finiDisplay = scalefilterOptionsFiniDisplay;
        scalefilterOptionsVTable.initScreen = scalefilterOptionsInitScreen;
        scalefilterOptionsVTable.finiScreen = scalefilterOptionsFiniScreen;
        scalefilterOptionsVTable.getScreenOptions = scalefilterOptionsGetScreenOptions;
	scalefilterOptionsVTable.setScreenOption = scalefilterOptionsSetScreenOption;
	
    }
    return &scalefilterOptionsVTable;
}

