/* $Id: cxp-dir-view.h,v 1.11 2005/09/03 12:55:35 yasumichi Exp $ */
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef	CXP_DIR_VIEW_H
#define	CXP_DIR_VIEW_H

#include <glib-object.h>
#include <gtk/gtk.h>

#define CXP_TYPE_DIR_VIEW             (cxp_dir_view_get_type ())
#define CXP_DIR_VIEW(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_DIR_VIEW, CxpDirView))
#define CXP_DIR_VIEW_CLASS(vtable)    (G_TYPE_CHECK_CLASS_CAST ((vtable), CXP_TYPE_DIR_VIEW, CxpDirViewClass))
#define CXP_IS_DIR_VIEW(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_DIR_VIEW))
#define CXP_IS_DIR_VIEW_CLASS(vtable) (G_TYPE_CHECK_CLASS_TYPE ((vtable), CXP_TYPE_DIR_VIEW))
#define CXP_DIR_VIEW_GET_CLASS(inst)  (G_TYPE_INSTANCE_GET_INTERFACE ((inst), CXP_TYPE_DIR_VIEW, CxpDirViewClass))

/*
 * ΥޥǤ
 */

typedef struct _CxpDirView CxpDirView;
typedef struct _CxpDirViewClass CxpDirViewClass;

struct _CxpDirView
{
	GtkScrolledWindow parent;
};

struct _CxpDirViewClass
{
	GtkScrolledWindowClass parent;

	void (* directory_changed) (CxpDirView *dir_view);
};

/* ޥ CXP_TYPE_DIR_VIEW() Ѥޤ*/
GType cxp_dir_view_get_type (void);

/*
 * API
 */
GtkWidget *cxp_dir_view_new (GConfClient *client);
gchar *cxp_dir_view_get_current_directory (CxpDirView *instance);
gboolean cxp_dir_view_change_directory (CxpDirView *instance, const gchar *fullpath);
void cxp_dir_view_refresh (CxpDirView *instance);

#endif /* CXP_DIR_VIEW_H */
