/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef CXP_RIGHT_PANE_H
#define CXP_RIGHT_PANE_H

/*
 * Potentially, include other headers on which this header depends.
 */
#include <cxp.h>

#define CXP_TYPE_RIGHT_PANE		  (cxp_right_pane_get_type ())
#define CXP_RIGHT_PANE(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), CXP_TYPE_RIGHT_PANE, CxpRightPane))
#define CXP_RIGHT_PANE_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), CXP_TYPE_RIGHT_PANE, CxpRightPaneClass))
#define CXP_IS_RIGHT_PANE(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CXP_TYPE_RIGHT_PANE))
#define CXP_IS_RIGHT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CXP_TYPE_RIGHT_PANE))
#define CXP_RIGHT_PANE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), CXP_TYPE_RIGHT_PANE, CxpRightPaneClass))

typedef struct _CxpRightPane CxpRightPane;
typedef struct _CxpRightPaneClass CxpRightPaneClass;

struct _CxpRightPane
{
	GtkVBox parent;
};

struct _CxpRightPaneClass
{
	GtkVBoxClass parent;

	void (* dir_double_clicked) (CxpRightPane *right_pane);
	void (* up_dir_request) (CxpRightPane *right_pane);
	void (* search_end) (CxpRightPane *right_pane);
};

/* used by CXP_TYPE_RIGHT_PANE */
GType cxp_right_pane_get_type (void);

/* API. */
GtkWidget *cxp_right_pane_new (GConfClient *client);
void cxp_right_pane_change_directory (CxpRightPane *self, const gchar *dirname);
gchar *cxp_right_pane_get_active_file_name (CxpRightPane *right_pane);
void cxp_right_pane_make_file (CxpRightPane *right_pane, const gchar *base_name);
void cxp_right_pane_delete_selected_files (CxpRightPane *right_pane);
void cxp_right_pane_copy_to_clipboard (CxpRightPane *right_pane);
void cxp_right_pane_paste_from_clipboard (CxpRightPane *right_pane);
void cxp_right_pane_rename_file_request (CxpRightPane *right_pane);
void cxp_right_pane_send_file_to_command (CxpRightPane *right_pane, const gchar *cmd);
void cxp_right_pane_set_cmd_request (CxpRightPane *right_pane);
void cxp_right_pane_set_popup_menu (CxpRightPane *right_pane, GtkWidget *popup_menu);
void cxp_right_pane_search_file (CxpRightPane *right_pane, const gchar *cmd);

#endif /* CXP_RIGHT_PANE_H */
