<?xml version='1.0'?>
<!-- vim: sw=2 sta et
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
                xmlns="http://docbook2x.sourceforge.net/xmlns/Man-XML"
                exclude-result-prefixes="doc"
                version='1.0'
                xml:lang="en">

<!-- ********************************************************************
     $Id: manpage.xsl,v 1.5 2004/08/22 22:46:04 stevecheng Exp $
     ********************************************************************

     (C) 2000-2004 Steve Cheng <stevecheng@users.sourceforge.net>

     This file is part of the docbook2X XSLT stylesheets for
     converting DocBook to man pages.

     See ../../COPYING for the copyright status of this software.

     ******************************************************************** -->
     
<doc:reference xmlns="">
<title>Man page chunk</title>
</doc:reference>

<!-- ==================================================================== -->

<xsl:template name="manpage">
  <xsl:param name="title" />
  <xsl:param name="section" select="$default-manpage-section" />
  <xsl:param name="h1" select="$title" />
  <xsl:param name="h2" select="$section" />
  
  <xsl:param name="h3" select="$header-3" />
  <xsl:param name="h4" select="$header-4" />
  <xsl:param name="h5" select="$header-5" />

  <xsl:param name="content">
    <xsl:apply-templates />
  </xsl:param>
  
  <manpage title="{$title}" sect="{$section}"
            h1="{$h1}" h2="{$h2}"
            h3="{$h3}" h4="{$h4}" h5="{$h5}">

    <xsl:attribute name="preprocessors">
      <xsl:if test=".//tgroup">
        <xsl:text>t</xsl:text>
      </xsl:if>
    </xsl:attribute>

    <xsl:copy-of select="$content" />
            
  </manpage>
</xsl:template>
            
</xsl:stylesheet>
