/**

	playlist.h

	Playlists' engine header file

**/

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <qstring.h>

struct tags
{
	tags() : tagLengthSeconds(0) {};

	void operator=(const tags & t)
	{
		tagTitle = t.tagTitle;
		tagAlbum = t.tagAlbum;
		tagArtist = t.tagArtist;
		tagBitrate = t.tagBitrate;
		tagLength = t.tagLength;
		tagLengthSeconds = t.tagLengthSeconds;
	}

	QString tagTitle;
	QString tagAlbum;
	QString tagArtist;
	QString tagBitrate;
	QString tagLength;
	int tagLengthSeconds;
};

struct exTags
{
	void operator=(const exTags & et)
	{
		basic = et.basic;

		tagYear = et.tagYear;
		tagComment = et.tagComment;
		tagTrack = et.tagTrack;
		tagGenre = et.tagGenre;
	}

	tags basic;

	QString tagYear;
	QString tagComment;
	QString tagTrack;
	QString tagGenre;
};

struct id
{
	id(const int & pre) : previous(pre), current(pre) {};

	int previous;
	int current;
};

struct length
{
	length() : h(0), m(0), s(0) {};

	void operator+=(const unsigned int & sec)
	{
		unsigned short int total_s, tmp_m;
		
		total_s = (sec + s);
		
		s = (total_s % 60);
		tmp_m = (m + ((total_s - s) / 60));
		m = (tmp_m % 60);
		h += ((tmp_m - m) / 60);
	}

	void operator-=(const unsigned int & sec)
	{
		while (s < sec)
		{
			if (m == 0)
			{
				if (h <= 0)
					goto reset;

				h--;
				m = 60;
			}

			if (m <= 0)
				goto reset;

			m--;
			s += 60;
		}

		s -= sec;

		return;

reset:
		clear();
	}

	void operator-=(const length & len)
	{
		(*this) -= ((len.h * 3600) + (len.m * 60) + len.s);
	}

	void operator++()
	{
		(*this) += 1;
	}

	void operator=(const unsigned int & sec)
	{
		(*this).clear();
		(*this) += sec;
	}

	void clear()
	{
		h = 0;
		m = 0;
		s = 0;
	}

	bool isZero()
	{
		if ((h == 0) && (m == 0) && (s == 0))
			return true;
		else
			return false;
	}

	unsigned int h;
	unsigned short int m;
	unsigned short int s;
};

struct pList
{
	pList()
	{
		myId = 0;
		previous = 0;
		next = 0;
	}

	QString trackName;
	QString filePath;
	tags fileTags;

	id * myId;

	pList * next;
	pList * previous;
};

struct pListIndex
{
	pListIndex()
	{
		count = 0;
		list = 0;
		previous = 0;
		next = 0;
		last = 0;
		recent_i = -1;
		recent = 0;
	}

	QString name;
	QString description;
	length len;
	int count;

	pList * list;
	pList * last;
	mutable int recent_i;
	mutable pList * recent;

	pListIndex * next;
	pListIndex * previous;
};

class Playlist
{
	public:
		Playlist();
		~Playlist();

		pListIndex * newPlaylist(const QString & name, const QString & descr);
		void setPlaylistName(pListIndex * const index, const QString & name);
		QString getPlaylistName(const pListIndex * const index) const;
		void setPlaylistDescr(pListIndex * const index, const QString & descr);
		QString getPlaylistDescr(const pListIndex * const index) const;
		void delPlaylist(pListIndex * const index);
		pListIndex * getPlaylist(const int & which) const;
		void movePlaylist(const int & which, const int & where, int & current, int & dest);
		unsigned int getCount() const;
		int getPlaylistCount() const;
		length getTotalLength() const;

		pList * add(pListIndex * const index, const QString & name, const QString & path,
			const tags * const ftags);
		void del(pListIndex * const index, const int & which);
		void up(pListIndex * const index, const int & which);
		void down(pListIndex * const index, const int & which);
		void up(pListIndex * const index, pList * item);
		void down(pListIndex * const index, pList * item);
		void swap(pListIndex * const index, const int & which, const int & where);
		void move(pListIndex * const index, const int & which, const int & where);
		pList * get(const pListIndex * const index, const int & which) const;

		int rmDup(pListIndex * const index, const int & pI);
		int rmDead(pListIndex * const index, const int & pI);
		void sort(pListIndex * const index, const unsigned short int & type, const bool & order);
		void shuffle(pListIndex * const index);

	private:
		pListIndex * mainIndex;
		pListIndex * mainGuard;
		unsigned int count;
		int playlistCount;
		length totalLen;
		
		enum sortBy {SORT_TITLE = 0, SORT_ALBUM, SORT_ARTIST, SORT_BITRATE, SORT_LENGTH};

		int assignId(const pListIndex * const index);
		int abs(const int & val) const;
		void qSort(pListIndex * const index, const int & first, const int & last, const unsigned short int & type, const bool & order);
};

#endif
