#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "ignore.h"
#include "listwindow.h"
#include "showlist.h"
#include "v7send.h"
#include "v7snac13.h"
#include "groups.h"
#include "gnomecfg.h"

#include <gtk/gtkstock.h>
#include <string.h>

static void modify_ignore_list( GtkWidget *widget, gpointer data );

static gboolean is_ignore (CONTACT_PTR contact);

gboolean is_ignore (CONTACT_PTR contact)
{
	return (contact ? contact->ignore_list : FALSE);
}

void ignore_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("Ignore List"),
			_("Drag the users you wish to add to your\n"
			  "ignore list into this window, and then click\n"
			  "the \"Ok\" button below."),
			GTK_STOCK_OK, NULL,
			G_CALLBACK (modify_ignore_list),
			is_ignore
		);
		gtk_widget_show_all( dlg );
		g_object_add_weak_pointer (G_OBJECT (dlg), (gpointer *)&dlg);
	} else {
		gtk_window_present (GTK_WINDOW (dlg));
	}
}

void modify_ignore_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	gint method = 0;

	GSList *contact;
	gboolean inlist;

#ifdef TRACE_FUNCTION
	g_print( "modify_ignore_list\n" );
#endif

	contact = Contacts;
	while( contact != NULL ) {
	  if (kontakt->ignore_list == FALSE) {
	    for( cx = 0; cx < clist->rows; cx ++ ) {
	      gtk_clist_get_text( clist, cx, 0, &uin );
	      if( !strcmp (uin, kontakt->uin) ) {
		v7_ignore (mainconnection, kontakt->uin,
			   kontakt->ignorelist_uid = contact_gen_uid (),
			   TRUE); /* add */
		kontakt->ignore_list = TRUE;
		/*
		if (kontakt->invis_list == FALSE) {
		  v7_invisible (mainconnection, kontakt->uin,
				kontakt->invlist_uid=contact_gen_uid (),
				TRUE);
		  kontakt->invis_list = TRUE;
		} */
		if (kontakt->vis_list == TRUE) {
		  v7_visible (mainconnection, kontakt->uin, 
				kontakt->vislist_uid, FALSE); /* remove */
		  kontakt->vislist_uid = 0;
		  kontakt->vis_list = FALSE;
		    
		}                                
	      } 
	    
	    }
	  } else {
	    gboolean isok = FALSE;
	    for( cx = 0; cx < clist->rows; cx ++ ) {
	      gtk_clist_get_text( clist, cx, 0, &uin );
	      if( !strcmp (uin, kontakt->uin) ) {
		isok = TRUE;
		break;
	      }
	    }
	    if (!isok) {
	      v7_ignore (mainconnection, kontakt->uin,
			 kontakt->ignorelist_uid,
			 FALSE); /* add */
	      kontakt->ignore_list = FALSE;
	      /*
	      if (kontakt->ignore_list == TRUE) {
		v7_invisible (mainconnection, kontakt->uin, 
			      kontakt->invlist_uid, FALSE);
		kontakt->invlist_uid = 0;
		kontakt->invis_list = FALSE;
	      }
	    */
	    }
	  }
	  contact = contact->next;

	}


	
	Save_RC();
}
