/***************************************************************************
*   Copyright (C) 2004 by  ͤ                                            *
*   tasuku@linux-life.net                                                 *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "cannadic.h"
#include <kglobal.h>
#include <qfile.h>
#include <kdebug.h>
#include <qtextstream.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <qstringlist.h>

CannaDic::CannaDic()
{
	m_datafile = locateLocal( "data", KGlobal::instance()->instanceName() + "/" + DATAFILE );
	getDataFile();
	readData();
}

bool CannaDic::readData()
{
	QFile file( m_datafile );
	if( !file.open( IO_ReadOnly ) ){
		kdError() << "Could not open " << m_datafile << "." << endl;
		KApplication::kApplication()->exit( 1 );
		return false;
	}

	QTextStream in( &file );
	QStringList list;
	Type type;
	while( !in.atEnd() ){
		list = QStringList::split( "\t", in.readLine(), true );
		type.code = list[0];
		type.category = list[1];
		type.name = list[2];
		type.example = list[3];
		type.major = ( list[4] == "true" );
		push_back( type );
	}
	return true;
}

bool CannaDic::saveData()
{
	QFile file( m_datafile );
	if( !file.open( IO_WriteOnly ) ){
		kdError() << "Could not open " << m_datafile << "." << endl;
		KApplication::kApplication()->exit( 1 );
		return false;
	}

	QTextStream out( &file );
	for( iterator it = begin(); it != end(); ++it ){
		out << (*it).code << '\t';
		out << (*it).category << '\t';
		out << (*it).name << '\t';
		out << (*it).example << '\t';
		out << ( (*it).major ? "true" : "false" ) << endl;
	}
	return true;
}

void CannaDic::print()
{
	for( iterator it = begin(); it != end(); ++it ){
		kdDebug() << (*it).code << "\t"
			<< (*it).category << "\t"
			<< (*it).name << "\t"
			<< (*it).example << "\t"
			<< ( (*it).major ? "true" : "false" ) << endl;
	}
}
bool CannaDic::getDataFile()
{
	if( QFile::exists( (const QString&)m_datafile ) ) return true;

	QFile org( KGlobal::dirs()->findResource( "data", KGlobal::instance()->instanceName() + "/" + DATAFILE ) );
	QFile local( m_datafile );
	if( !org.open( IO_ReadOnly ) ){
		kdError() << "Could not open " << org.name() << "." << endl;
		KApplication::kApplication()->exit( 1 );
		return false;
	}
	if( !local.open( IO_WriteOnly ) ){
		kdError() << "Could not open " << m_datafile << "." << endl;
		KApplication::kApplication()->exit( 1 );
		return false;
	}

	QTextStream in( &org );
	QTextStream out( &local );

	while( !in.atEnd() ){
		out << in.readLine() << endl;
	}
	org.close();
	local.close();
	return true;
}

Type CannaDic::code2type( QString code )
{
	for( iterator it = begin(); it != end(); ++it ){
		if( (*it).code == code ) return (*it);
	}
	return *(begin());
}

CannaDic::~CannaDic()
{
}
