/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dlgpreference.h"

#include "canna.h"
#include "anthy.h"

#include <klocale.h>
#include <kdebug.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qgrid.h>
#include <kconfig.h>
#include <kmessagebox.h>

dlgPreference::dlgPreference( QWidget *parent, const char *name)
 : KDialogBase( KDialogBase::Tabbed, i18n("Configure"), Ok|Cancel, Ok, parent, name, true )
{
	if( Canna::isAvailable() ){
		addCanna();
	}
	if( Anthy::isAvailable() ){
		addAnthy();
	}
	readConfiguration();
}

void dlgPreference::addCanna()
{
	QLabel* lbl;
	QGrid* grid;
	QVBox* vbox = addVBoxPage( QString("Canna") );

	grid = new QGrid( 2, Qt::Horizontal, vbox );

	chkAutoEditDotFile = new QCheckBox( i18n( "Auto edit .canna" ), grid );
	chkConfirmAutoEditDotFile = new QCheckBox( i18n( "Confirm" ), grid );

	chkAutoRestartXIM = new QCheckBox( i18n( "Auto restart xim" ), grid );
	chkConfirmAutoRestartXIM = new QCheckBox( i18n( "Confirm" ), grid );

	grid = new QGrid( 2, Qt::Horizontal, vbox );

	lbl = new QLabel( i18n( "Start command" ), grid );
	cbxXIMStartCommand = new KComboBox( grid );
	lbl->setBuddy( cbxXIMStartCommand );
	cbxXIMStartCommand->setEditable( true );
	cbxXIMStartCommand->insertItem( "kinput2 -canna -xim" );

	lbl = new QLabel( i18n( "Stop command" ), grid );
	cbxXIMStopCommand = new KComboBox( grid );
	lbl->setBuddy( cbxXIMStopCommand );
	cbxXIMStopCommand->setEditable( true );
	cbxXIMStopCommand->insertItem( "killall kinput2" );
}

void dlgPreference::addAnthy()
{
	QGrid* grid;
	QVBox* vbox = addVBoxPage( QString("Anthy") );

	grid = new QGrid( 2, Qt::Horizontal, vbox );

	chkAutoOpenAnthy = new QCheckBox( i18n( "Auto open Anthy" ), grid );
	chkConfirmAutoOpenAnthy = new QCheckBox( i18n( "Confirm" ), grid );
}

dlgPreference::~dlgPreference()
{
}

void dlgPreference::slotOk()
{
	writeConfiguration();
	emit okClicked();
	accept();
}

void dlgPreference::readConfiguration()
{
	bool confirm;
	KMessageBox::ButtonCode btn;
	KConfig *conf = KGlobal::config();
	if( Canna::isAvailable() ){
		conf->setGroup("Canna");

		confirm = KMessageBox::shouldBeShownYesNo( "AutoEditDotFile", btn );
		chkConfirmAutoEditDotFile->setChecked( confirm );
		if( confirm ){
			chkAutoEditDotFile->setChecked( conf->readBoolEntry( "AutoEditDotFile", false ) );
		}else{
			chkAutoEditDotFile->setChecked( btn == KMessageBox::Yes );
		}

		confirm = KMessageBox::shouldBeShownYesNo( "AutoRestartXIM", btn );
		chkConfirmAutoRestartXIM->setChecked( confirm );
		if( confirm ){
			chkAutoRestartXIM->setChecked( conf->readBoolEntry( "AutoRestartXIM", false ) );
		}else{
			chkAutoRestartXIM->setChecked( btn == KMessageBox::Yes );
		}

		cbxXIMStartCommand->setCurrentText( conf->readEntry( "XIMStartCommand" ) );
		cbxXIMStopCommand->setCurrentText( conf->readEntry( "XIMStopCommand" ) );
	}
	if( Anthy::isAvailable() ){
		conf->setGroup("Anthy");
		confirm = KMessageBox::shouldBeShownYesNo( "AutoOpenAnthy", btn );
		kdDebug() << confirm << endl;
		chkConfirmAutoOpenAnthy->setChecked( confirm );
		if( confirm ){
			chkAutoOpenAnthy->setChecked( conf->readBoolEntry( "AutoOpenAnthy", false ) );
		}else{
			chkAutoOpenAnthy->setChecked( btn == KMessageBox::Yes );
		}

	}
}

void dlgPreference::writeConfiguration()
{
	KMessageBox::ButtonCode btn;
	KConfig *conf = KGlobal::config();
	if( Canna::isAvailable() ){
		conf->setGroup("Canna");

		if( chkConfirmAutoEditDotFile->isChecked() ){
			conf->writeEntry( "AutoEditDotFile", chkAutoEditDotFile->isChecked() );
			KMessageBox::enableMessage( "AutoEditDotFile" );
		}else{
			btn = chkAutoEditDotFile->isChecked() ? KMessageBox::Yes : KMessageBox::No;
			KMessageBox::saveDontShowAgainYesNo( "AutoEditDotFile", btn );
		}

		if( chkConfirmAutoRestartXIM->isChecked() ){
			conf->writeEntry( "AutoRestartXIM", chkAutoRestartXIM->isChecked() );
			KMessageBox::enableMessage( "AutoRestartXIM" );
		}else{
			btn = chkAutoRestartXIM->isChecked() ? KMessageBox::Yes : KMessageBox::No;
			KMessageBox::saveDontShowAgainYesNo( "AutoRestartXIM", btn );
		}

		conf->writeEntry( "XIMStartCommand", cbxXIMStartCommand->currentText() );
		conf->writeEntry( "XIMStopCommand", cbxXIMStopCommand->currentText() );
	}
	if( Anthy::isAvailable() ){
		conf->setGroup("Anthy");
		if( chkConfirmAutoOpenAnthy->isChecked() ){
			conf->writeEntry( "AutoOpenAnthy", chkAutoOpenAnthy->isChecked() );
			KMessageBox::enableMessage( "AutoOpenAnthy" );
		}else{
			btn = chkAutoOpenAnthy->isChecked() ? KMessageBox::Yes : KMessageBox::No;
			KMessageBox::saveDontShowAgainYesNo( "AutoOpenAnthy", btn );
		}
	}
}
