/***************************************************************************
 *   Copyright (C) 2007 by Johannes Schaub                                 *
 *   schaub-johannes@web.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CPUUSAGESRC_H
#define CPUUSAGESRC_H
#include "labelsource.h"
#include "threadedtrigger.h"
#include <qfile.h>
#include <list>

/**
 * CpuUsageSrc reads numbers from /proc/stats and calcs the usage from it
 */
class CpuUsageSrc : public LabelSource {
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new Source from the given File
	 */
	CpuUsageSrc(QWidget* inParent, const QFile& inSourceFile, int index);
	virtual ~CpuUsageSrc();

	/**
	 * Creates instances of that Source (and returns pointers to them)
	 */
	static std::list<Source*> createInstances(QWidget* inParent);	

	/**
	 * Fetches and returns the value of this source
	 * This method is called from a thread so don't call it directly
	 */
	virtual QString fetchValue();

private:
	/**
	 * The file from which the value is read
	 */
	QFile mSourceFile;

    /**
     * The last values of cpu usage
     */
    unsigned int mLastUsage[7];

    /**
     * the cpu number to stat
     */
    int mIndex;

    /**
     * the pattern to match in the /proc/stat file
     */
    QString mPattern;

	/**
	 * triggers the fetchValue method
	 */
	ThreadedTrigger mTrigger;
};
#endif //CPUUSAGESRC_H

