/***************************************************************************
                          confdialog.cpp  -  description
                             -------------------
    begin                : May 7 22:18:34 BST 2004
    copyright            : (C) 2003-2005 by KSmoothDock team
    email                : dangvd@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/// @TODO: re-format the file according to KSmoothDock v4.0's coding style

#include "configdialog.h"

#include <klocale.h>

#include <qvariant.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qradiobutton.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qslider.h>
#include <kcolorbutton.h>
#include <knuminput.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kmessagebox.h>
#include <kfontdialog.h>

#include "constants.h"
#include "ksmoothdock.h"


/*
 *  Constructs a ConfigDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConfigDialog::ConfigDialog( KSmoothDock* parent, const char* name, bool modal, WFlags fl )
    : QDialog( (QWidget*) parent, name, modal, fl )
{
    m_parent = parent;
    if ( !name )
	    setName( "KSmoothDock Preferences" );
    setSizeGripEnabled( TRUE );

    buttonApply = new QPushButton( this, "buttonApply" );
    buttonApply->setGeometry( QRect( 240, 530, 130, 30 ) );
    buttonApply->setAutoDefault( TRUE );
    buttonApply->setDefault( TRUE );

    buttonQuit = new QPushButton( this, "buttonQuit" );
    buttonQuit->setGeometry( QRect( 460, 530, 110, 30 ) );
    buttonQuit->setAutoDefault( TRUE );

    tabPrefs = new QTabWidget( this, "tabPrefs" );
    tabPrefs->setGeometry( QRect( 20, 10, 770, 510 ) );

    Widget2 = new QWidget( tabPrefs, "Widget2" );

    groupBox2 = new QGroupBox( Widget2, "groupBox2" );
    groupBox2->setGeometry( QRect( 30, 30, 670, 250 ) );

    textLabel1_3 = new QLabel( groupBox2, "textLabel1_3" );
    textLabel1_3->setGeometry( QRect( 160, 160, 261, 41 ) );

    textLabel6 = new QLabel( groupBox2, "textLabel6" );
    textLabel6->setGeometry( QRect( 80, 20, 340, 41 ) );

    cbPager = new QCheckBox( groupBox2, "cbPager" );
    cbPager->setGeometry( QRect( 30, 80, 20, 20 ) );

    cbTaskbar = new QCheckBox( groupBox2, "cbTaskbar" );
    cbTaskbar->setGeometry( QRect( 30, 130, 20, 20 ) );

    cbClock = new QCheckBox( groupBox2, "cbClock" );
    cbClock->setGeometry( QRect( 30, 210, 20, 20 ) );

    cbShowWinAllDesks = new QCheckBox( groupBox2, "cbShowWinAllDesks" );
    cbShowWinAllDesks->setGeometry( QRect( 110, 170, 20, 20 ) );

    cbQuickLaunch = new QCheckBox( groupBox2, "cbQuickLaunch" );
    cbQuickLaunch->setEnabled( FALSE );
    cbQuickLaunch->setGeometry( QRect( 30, 30, 20, 21 ) );
    cbQuickLaunch->setChecked( TRUE );

    textLabel7 = new QLabel( groupBox2, "textLabel7" );
    textLabel7->setGeometry( QRect( 80, 74, 171, 31 ) );

    textLabel2_3 = new QLabel( groupBox2, "textLabel2_3" );
    textLabel2_3->setGeometry( QRect( 80, 125, 70, 31 ) );

    textLabel9 = new QLabel( groupBox2, "textLabel9" );
    textLabel9->setGeometry( QRect( 80, 200, 141, 41 ) );
    tabPrefs->insertTab( Widget2, QString("") );

    Widget3 = new QWidget( tabPrefs, "Widget3" );

    grbParabolic = new QGroupBox( Widget3, "grbParabolic" );
    grbParabolic->setGeometry( QRect( 30, 330, 671, 120 ) );

    textLabel1_6_2 = new QLabel( grbParabolic, "textLabel1_6_2" );
    textLabel1_6_2->setGeometry( QRect( 120, 55, 141, 31 ) );

    textLabel2_5_2 = new QLabel( grbParabolic, "textLabel2_5_2" );
    textLabel2_5_2->setGeometry( QRect( 270, 80, 50, 31 ) );

    textLabel3_4_2 = new QLabel( grbParabolic, "textLabel3_4_2" );
    textLabel3_4_2->setGeometry( QRect( 610, 80, 40, 31 ) );

    sldSpeedPZ = new QSlider( grbParabolic, "sldSpeedPZ" );
    sldSpeedPZ->setGeometry( QRect( 280, 60, 350, 21 ) );
    sldSpeedPZ->setMinValue( 1 );
    sldSpeedPZ->setMaxValue( 31 );
    sldSpeedPZ->setOrientation( QSlider::Horizontal );

    grbNormal = new QGroupBox( Widget3, "grbNormal" );
    grbNormal->setGeometry( QRect( 30, 210, 671, 100 ) );

    textLabel1_6 = new QLabel( grbNormal, "textLabel1_6" );
    textLabel1_6->setGeometry( QRect( 120, 34, 141, 31 ) );

    textLabel2_5 = new QLabel( grbNormal, "textLabel2_5" );
    textLabel2_5->setGeometry( QRect( 270, 60, 50, 31 ) );

    textLabel3_4 = new QLabel( grbNormal, "textLabel3_4" );
    textLabel3_4->setGeometry( QRect( 610, 60, 40, 31 ) );

    sldSpeedNZ = new QSlider( grbNormal, "sldSpeedNZ" );
    sldSpeedNZ->setGeometry( QRect( 280, 40, 350, 21 ) );
    sldSpeedNZ->setMinValue( 1 );
    sldSpeedNZ->setMaxValue( 31 );
    sldSpeedNZ->setOrientation( QSlider::Horizontal );

    groupBox1 = new QGroupBox( Widget3, "groupBox1" );
    groupBox1->setGeometry( QRect( 30, 30, 670, 160 ) );

    buttonGroup2 = new QButtonGroup( groupBox1, "buttonGroup2" );
    buttonGroup2->setGeometry( QRect( 20, 30, 350, 70 ) );
    buttonGroup2->setLineWidth( 0 );

    textLabel3 = new QLabel( buttonGroup2, "textLabel3" );
    textLabel3->setGeometry( QRect( 130, -10, 221, 41 ) );

    textLabel4 = new QLabel( buttonGroup2, "textLabel4" );
    textLabel4->setGeometry( QRect( 130, 28, 180, 40 ) );

    rbNormalZoom = new QRadioButton( buttonGroup2, "rbNormalZoom" );
    rbNormalZoom->setGeometry( QRect( 80, 0, 16, 21 ) );

    rbParabolicZoom = new QRadioButton( buttonGroup2, "rbParabolicZoom" );
    rbParabolicZoom->setGeometry( QRect( 80, 32, 16, 31 ) );

    textLabel1_2 = new QLabel( groupBox1, "textLabel1_2" );
    textLabel1_2->setGeometry( QRect( 90, 110, 520, 40 ) );
    tabPrefs->insertTab( Widget3, QString("") );

    TabPage = new QWidget( tabPrefs, "TabPage" );

    gbPosition = new QGroupBox( TabPage, "gbPosition" );
    gbPosition->setGeometry( QRect( 20, 10, 700, 60 ) );

    lbPosition = new QLabel( gbPosition, "lbPosition" );
    lbPosition->setGeometry( QRect( 20, 20, 520, 30 ) );

    cbbPosition = new QComboBox( gbPosition, "cbbPosition" );
    cbbPosition->setGeometry( QRect( 120, 20, 100, 30 ) );

    groupBox15 = new QGroupBox( TabPage, "groupBox15" );
    groupBox15->setGeometry( QRect( 20, 80, 700, 380 ) );

    groupBox3 = new QGroupBox( groupBox15, "groupBox3" );
    groupBox3->setGeometry( QRect( 20, 20, 660, 160 ) );

    sldSmallIconNZ = new QSlider( groupBox3, "sldSmallIconNZ" );
    sldSmallIconNZ->setGeometry( QRect( 160, 30, 340, 24 ) );
    sldSmallIconNZ->setOrientation( QSlider::Horizontal );
    sldSmallIconNZ->setTickmarks( QSlider::NoMarks );

    textLabel2_2 = new QLabel( groupBox3, "textLabel2_2" );
    textLabel2_2->setGeometry( QRect( 20, 22, 131, 31 ) );

    sldBigIconNZ = new QSlider( groupBox3, "sldBigIconNZ" );
    sldBigIconNZ->setGeometry( QRect( 160, 70, 340, 24 ) );
    sldBigIconNZ->setOrientation( QSlider::Horizontal );
    sldBigIconNZ->setTickmarks( QSlider::NoMarks );

    edtSmallIconNZ = new QLineEdit( groupBox3, "edtSmallIconNZ" );
    edtSmallIconNZ->setGeometry( QRect( 570, 20, 51, 31 ) );
    edtSmallIconNZ->setReadOnly( TRUE );

    textLabel2_2_2 = new QLabel( groupBox3, "textLabel2_2_2" );
    textLabel2_2_2->setGeometry( QRect( 20, 64, 131, 31 ) );

    textLabel8 = new QLabel( groupBox3, "textLabel8" );
    textLabel8->setGeometry( QRect( 20, 110, 384, 31 ) );

    cbbBaseIconSizeNZ = new QComboBox( FALSE, groupBox3, "cbbBaseIconSizeNZ" );
    cbbBaseIconSizeNZ->setGeometry( QRect( 440, 110, 110, 31 ) );

    edtBigIconNZ = new QLineEdit( groupBox3, "edtBigIconNZ" );
    edtBigIconNZ->setGeometry( QRect( 570, 64, 51, 31 ) );
    edtBigIconNZ->setReadOnly( TRUE );

    groupBox4 = new QGroupBox( groupBox15, "groupBox4" );
    groupBox4->setGeometry( QRect( 20, 190, 660, 161 ) );

    sldSmallIconPZ = new QSlider( groupBox4, "sldSmallIconPZ" );
    sldSmallIconPZ->setGeometry( QRect( 160, 30, 340, 24 ) );
    sldSmallIconPZ->setOrientation( QSlider::Horizontal );
    sldSmallIconPZ->setTickmarks( QSlider::NoMarks );

    textLabel2_2_3 = new QLabel( groupBox4, "textLabel2_2_3" );
    textLabel2_2_3->setGeometry( QRect( 20, 25, 131, 31 ) );

    sldBigIconPZ = new QSlider( groupBox4, "sldBigIconPZ" );
    sldBigIconPZ->setGeometry( QRect( 160, 70, 340, 24 ) );
    sldBigIconPZ->setOrientation( QSlider::Horizontal );
    sldBigIconPZ->setTickmarks( QSlider::NoMarks );

    edtSmallIconPZ = new QLineEdit( groupBox4, "edtSmallIconPZ" );
    edtSmallIconPZ->setGeometry( QRect( 570, 20, 51, 31 ) );
    edtSmallIconPZ->setReadOnly( TRUE );

    textLabel2_2_2_2 = new QLabel( groupBox4, "textLabel2_2_2_2" );
    textLabel2_2_2_2->setGeometry( QRect( 20, 64, 110, 31 ) );

    textLabel8_2 = new QLabel( groupBox4, "textLabel8_2" );
    textLabel8_2->setGeometry( QRect( 20, 110, 390, 31 ) );

    cbbBaseIconSizePZ = new QComboBox( FALSE, groupBox4, "cbbBaseIconSizePZ" );
    cbbBaseIconSizePZ->setGeometry( QRect( 440, 110, 110, 31 ) );

    edtBigIconPZ = new QLineEdit( groupBox4, "edtBigIconPZ" );
    edtBigIconPZ->setGeometry( QRect( 570, 65, 51, 31 ) );
    edtBigIconPZ->setReadOnly( TRUE );
    tabPrefs->insertTab( TabPage, QString("") );
    
    TabPage_2 = new QWidget( tabPrefs, "TabPage_2" );

    groupBox17 = new QGroupBox( TabPage_2, "groupBox17" );
    groupBox17->setGeometry( QRect( 20, 20, 680, 80 ) );
    
    textLabel5_3 = new QLabel( groupBox17, "textLabel5_3" );
    textLabel5_3->setGeometry( QRect( 70, 20, 261, 41 ) );

    cbAutohide = new QCheckBox( groupBox17, "cbAutohide" );
    cbAutohide->setGeometry( QRect( 30, 30, 20, 20 ) );
    tabPrefs->insertTab( TabPage_2, QString("") );

    TabPage_3 = new QWidget( tabPrefs, "TabPage_3" );

    groupBox5 = new QGroupBox( TabPage_3, "groupBox5" );
    groupBox5->setGeometry( QRect( 20, 20, 640, 130 ) );

    textLabel4_2 = new QLabel( groupBox5, "textLabel4_2" );
    textLabel4_2->setGeometry( QRect( 130, 80, 110, 31 ) );

    btnBorderColor = new KColorButton( groupBox5, "btnBorderColor" );
    btnBorderColor->setGeometry( QRect( 250, 70, 60, 40 ) );

    cbBorders = new QCheckBox( groupBox5, "cbBorders" );
    cbBorders->setGeometry( QRect( 30, 40, 20, 20 ) );

    textLabel3_2 = new QLabel( groupBox5, "textLabel3_2" );
    textLabel3_2->setGeometry( QRect( 71, 34, 121, 31 ) );

    groupBox6 = new QGroupBox( TabPage_3, "groupBox6" );
    groupBox6->setGeometry( QRect( 20, 170, 640, 250 ) );

    textLabel5_2 = new QLabel( groupBox6, "textLabel5_2" );
    textLabel5_2->setGeometry( QRect( 40, 40, 141, 31 ) );

    btnBgColor = new KColorButton( groupBox6, "btnBgColor" );
    btnBgColor->setGeometry( QRect( 250, 30, 60, 40 ) );

    btnSepColor = new KColorButton( groupBox6, "btnSepColor" );
    btnSepColor->setGeometry( QRect( 250, 80, 60, 40 ) );

    btnActiveDeskColor = new KColorButton( groupBox6, "btnActiveDeskColor" );
    btnActiveDeskColor->setGeometry( QRect( 250, 130, 60, 40 ) );

    btnInactiveDeskColor = new KColorButton( groupBox6, "btnInactiveDeskColor" );
    btnInactiveDeskColor->setGeometry( QRect( 250, 180, 60, 40 ) );

    textLabel6_2 = new QLabel( groupBox6, "textLabel6_2" );
    textLabel6_2->setGeometry( QRect( 40, 82, 131, 41 ) );

    textLabel7_2_2 = new QLabel( groupBox6, "textLabel7_2_2" );
    textLabel7_2_2->setGeometry( QRect( 40, 176, 171, 51 ) );

    textLabel7_2 = new QLabel( groupBox6, "textLabel7_2" );
    textLabel7_2->setGeometry( QRect( 40, 125, 171, 51 ) );
    tabPrefs->insertTab( TabPage_3, QString("") );

    TabPage_4 = new QWidget( tabPrefs, "TabPage_4" );

    groupBox10 = new QGroupBox( TabPage_4, "groupBox10" );
    groupBox10->setGeometry( QRect( 20, 30, 640, 90 ) );

    textLabel10 = new QLabel( groupBox10, "textLabel10" );
    textLabel10->setGeometry( QRect( 30, 30, 110, 40 ) );

    edtOpacity = new QLineEdit( groupBox10, "edtOpacity" );
    edtOpacity->setGeometry( QRect( 540, 30, 51, 31 ) );
    edtOpacity->setReadOnly( TRUE );

    sldOpacity = new QSlider( groupBox10, "sldOpacity" );
    sldOpacity->setGeometry( QRect( 150, 40, 340, 24 ) );
    sldOpacity->setMaxValue( 100 );
    sldOpacity->setOrientation( QSlider::Horizontal );
    sldOpacity->setTickmarks( QSlider::NoMarks );
    sldOpacity->setTickInterval( 0 );

    groupBox9 = new QGroupBox( TabPage_4, "groupBox9" );
    //groupBox9->setGeometry( QRect( 20, 240, 640, 130 ) );

    textLabel11 = new QLabel( groupBox9, "textLabel11" );
    //textLabel11->setGeometry( QRect( 100, 70, 200, 31 ) );

    intScrWidth = new KIntNumInput( groupBox9, "intScrWidth" );
    //intScrWidth->setGeometry( QRect( 340, 70, 113, 27 ) );

    cbXinerama = new QCheckBox( groupBox9, "cbXinerama" );
    //cbXinerama->setGeometry( QRect( 30, 30, 20, 20 ) );

    textLabel1 = new QLabel( groupBox9, "textLabel1" );
    //textLabel1->setGeometry( QRect( 60, 25, 201, 31 ) );
    tabPrefs->insertTab( TabPage_4, QString("") );

    TabPage_5 = new QWidget( tabPrefs, "TabPage_5" );

    grbTooltips = new QGroupBox( TabPage_5, "grbTooltips" );
    grbTooltips->setGeometry( QRect( 20, 50, 730, 400 ) );

    groupBox13 = new QGroupBox( grbTooltips, "groupBox13" );
    groupBox13->setGeometry( QRect( 20, 21, 240, 360 ) );

    textLabel3_3 = new QLabel( groupBox13, "textLabel3_3" );
    textLabel3_3->setGeometry( QRect( 10, 90, 120, 51 ) );

    textLabel2 = new QLabel( groupBox13, "textLabel2" );
    textLabel2->setGeometry( QRect( 10, 30, 110, 41 ) );

    ttColor = new KColorButton( groupBox13, "ttColor" );
    ttColor->setGeometry( QRect( 150, 30, 60, 41 ) );

    ttBgColor = new KColorButton( groupBox13, "ttBgColor" );
    ttBgColor->setGeometry( QRect( 150, 90, 61, 41 ) );

    ttFont = new KFontChooser( grbTooltips, "ttFont" );
    ttFont->setGeometry( QRect( 280, 20, 430, 360 ) );

    textLabel1_4 = new QLabel( TabPage_5, "textLabel1_4" );
    textLabel1_4->setGeometry( QRect( 60, 10, 140, 41 ) );

    cbTooltips = new QCheckBox( TabPage_5, "cbTooltips" );
    cbTooltips->setGeometry( QRect( 20, 20, 20, 20 ) );
    tabPrefs->insertTab( TabPage_5, QString("") );

    TabPage_6 = new QWidget( tabPrefs, "TabPage_6" );

    buttonGroup3 = new QButtonGroup( TabPage_6, "buttonGroup3" );
    buttonGroup3->setGeometry( QRect( 20, 0, 730, 80 ) );

    rb24 = new QRadioButton( buttonGroup3, "rb24" );
    rb24->setGeometry( QRect( 29, 20, 20, 20 ) );

    rb12 = new QRadioButton( buttonGroup3, "rb12" );
    rb12->setGeometry( QRect( 29, 50, 20, 20 ) );

    textLabel5 = new QLabel( buttonGroup3, "textLabel5" );
    textLabel5->setGeometry( QRect( 90, 50, 170, 21 ) );

    textLabel4_3 = new QLabel( buttonGroup3, "textLabel4_3" );
    textLabel4_3->setGeometry( QRect( 90, 20, 101, 20 ) );

    groupBox14 = new QGroupBox( TabPage_6, "groupBox14" );
    groupBox14->setGeometry( QRect( 20, 80, 730, 390 ) );

    textLabel2_4 = new QLabel( groupBox14, "textLabel2_4" );
    textLabel2_4->setGeometry( QRect( 30, 30, 110, 41 ) );

    btnClockTextColor = new KColorButton( groupBox14, "btnClockTextColor" );
    btnClockTextColor->setGeometry( QRect( 150, 30, 60, 41 ) );

    fontClockText = new KFontChooser( groupBox14, "fontClockText" );
    fontClockText->setGeometry( QRect( 270, 20, 440, 357 ) );
    tabPrefs->insertTab( TabPage_6, QString("") );
    languageChange();
    resize( QSize(810, 572).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // init values

	sldSmallIconNZ->setMinValue(16);
    sldSmallIconNZ->setMaxValue(128);
	sldBigIconNZ->setMinValue(24);
    sldBigIconNZ->setMaxValue(192);

	sldSmallIconPZ->setMinValue(16);
    sldSmallIconPZ->setMaxValue(64);
	sldBigIconPZ->setMinValue(32);
    sldBigIconPZ->setMaxValue(192);

	cbShowWinAllDesks->setEnabled(cbTaskbar->isChecked());
	btnBorderColor->setEnabled(cbBorders->isChecked());
	intScrWidth->setEnabled(cbXinerama->isChecked());
	grbTooltips->setEnabled(cbTooltips->isChecked());

    grbParabolic->setEnabled(rbParabolicZoom->isChecked());
    grbNormal->setEnabled(!rbParabolicZoom->isChecked());

    // init values of slider displays

    edtOpacity->setText(QString::number(sldOpacity->value()));
    edtSmallIconNZ->setText(QString::number(sldSmallIconNZ->value()));
    edtBigIconNZ->setText(QString::number(sldBigIconNZ->value()));
    edtSmallIconPZ->setText(QString::number(sldSmallIconPZ->value()));
    edtBigIconPZ->setText(QString::number(sldBigIconPZ->value()));

    // signals and slots connections

    connect( cbTaskbar, SIGNAL( stateChanged(int) ), this, SLOT( cbTaskbar_stateChanged(int) ) );
    connect( buttonQuit, SIGNAL( clicked() ), this, SLOT( buttonQuit_clicked() ) );
    connect( cbBorders, SIGNAL( stateChanged(int) ), this, SLOT( cbBorders_stateChanged(int) ) );
    connect( cbXinerama, SIGNAL( stateChanged(int) ), this, SLOT( cbXinerama_stateChanged(int) ) );
    connect( buttonApply, SIGNAL( clicked() ), this, SLOT( buttonApply_clicked() ) );
    connect( sldOpacity, SIGNAL( valueChanged(int) ), this, SLOT( sldOpacity_valueChanged(int) ) );
    connect( sldSmallIconNZ, SIGNAL( valueChanged(int) ), this, SLOT( sldSmallIconNZ_valueChanged(int) ) );
    connect( sldBigIconNZ, SIGNAL( valueChanged(int) ), this, SLOT( sldBigIconNZ_valueChanged(int) ) );
    connect( sldSmallIconPZ, SIGNAL( valueChanged(int) ), this, SLOT( sldSmallIconPZ_valueChanged(int) ) );
    connect( sldBigIconPZ, SIGNAL( valueChanged(int) ), this, SLOT( sldBigIconPZ_valueChanged(int) ) );
	connect( cbTooltips, SIGNAL( stateChanged(int) ), this, SLOT( cbTooltips_stateChanged(int) ) );
    connect( rbParabolicZoom, SIGNAL( stateChanged(int) ), this, SLOT( rbParabolicZoom_stateChanged(int) ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
ConfigDialog::~ConfigDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void ConfigDialog::languageChange()
{
    setCaption( tr2i18n( "KSmoothDock Preferences" ) );
    buttonApply->setText( tr2i18n( "&Apply" ) );
    buttonApply->setAccel( QKeySequence( tr2i18n( "Alt+A" ) ) );
    buttonQuit->setText( tr2i18n( "&Close" ) );
    buttonQuit->setAccel( QKeySequence( tr2i18n( "Alt+C" ) ) );
    groupBox2->setTitle( tr2i18n( "The components of KSmoothDock you want to use" ) );
    textLabel1_3->setText( tr2i18n( "Show windows from all desktops" ) );
    textLabel6->setText( tr2i18n( "Quick launch menu (always enabled by default)" ) );
    cbPager->setText( QString::null );
    cbTaskbar->setText( tr2i18n( "checkBox3" ) );
    cbClock->setText( tr2i18n( "checkBox4" ) );
    cbShowWinAllDesks->setText( tr2i18n( "checkBox5" ) );
    cbQuickLaunch->setText( QString::null );
    textLabel7->setText( tr2i18n( "Pager" ) );
    textLabel2_3->setText( tr2i18n( "Taskbar" ) );
    textLabel9->setText( tr2i18n( "Clock" ) );
    tabPrefs->changeTab( Widget2, tr2i18n( "Panel &Components" ) );
    grbParabolic->setTitle( tr2i18n( "Parabolic Zooming Mode Options" ) );
    textLabel1_6_2->setText( tr2i18n( "Zooming Speed" ) );
    textLabel2_5_2->setText( tr2i18n( "Slow" ) );
    textLabel3_4_2->setText( tr2i18n( "Fast" ) );
    grbNormal->setTitle( tr2i18n( "Normal Smooth Zooming Mode Options" ) );
    textLabel1_6->setText( tr2i18n( "Zooming Speed" ) );
    textLabel2_5->setText( tr2i18n( "Slow" ) );
    textLabel3_4->setText( tr2i18n( "Fast" ) );
    groupBox1->setTitle( tr2i18n( "The zooming mode you want to use" ) );
    buttonGroup2->setTitle( QString::null );
    textLabel3->setText( tr2i18n( "Normal Smooth Zooming Mode" ) );
    textLabel4->setText( tr2i18n( "Parabolic Zooming Mode" ) );
    rbNormalZoom->setText( tr2i18n( "radioButton1" ) );
    rbParabolicZoom->setText( tr2i18n( "radioButton2" ) );
    textLabel1_2->setText( tr2i18n( "<font color=\"#aa0000\">Note: This option requires KSmoothDock to restart for the change to take effect</font>" ) );
    tabPrefs->changeTab( Widget3, tr2i18n( "Icon &Zooming" ) );    
    gbPosition->setTitle(i18n("Position"));
    lbPosition->setText(i18n("Panel Position"));
    groupBox15->setTitle( tr2i18n( "Icon Sizes" ) );
    groupBox3->setTitle( tr2i18n( "Normal Zooming Mode" ) );
    textLabel2_2->setText( tr2i18n( "Small icon size" ) );
    textLabel2_2_2->setText( tr2i18n( "Big icon size" ) );
    textLabel8->setText( tr2i18n( "When scaling quick launcher icons, load base icons with size" ) );
    cbbBaseIconSizeNZ->clear();
    cbbBaseIconSizeNZ->insertItem( tr2i18n( "64 x 64" ) );
    cbbBaseIconSizeNZ->insertItem( tr2i18n( "128 x 128" ) );
    QToolTip::add( cbbBaseIconSizeNZ, tr2i18n( "Bigger size may give clear look for quick launcher icons, but may also slow down KSmoothDock" ) );
    groupBox4->setTitle( tr2i18n( "Parabolic Zooming Mode" ) );
    textLabel2_2_3->setText( tr2i18n( "Small icon size" ) );
    textLabel2_2_2_2->setText( tr2i18n( "Big icon size" ) );
    textLabel8_2->setText( tr2i18n( "When scaling quick launcher icons, load base icons with size" ) );
    cbbBaseIconSizePZ->clear();
    cbbBaseIconSizePZ->insertItem( tr2i18n( "64 x 64" ) );
    cbbBaseIconSizePZ->insertItem( tr2i18n( "128 x 128" ) );
    QToolTip::add( cbbBaseIconSizePZ, tr2i18n( "Bigger size may give clear look for quick launcher icons, but may also slow down KSmoothDock" ) );
    tabPrefs->changeTab( TabPage, tr2i18n( "Arran&gement" ) );
    cbbPosition->insertItem(tr2i18n("Top"));
    cbbPosition->insertItem(tr2i18n("Bottom"));
    cbbPosition->insertItem(tr2i18n("Left"));
    cbbPosition->insertItem(tr2i18n("Right"));
    groupBox17->setTitle( tr2i18n( "Hide Mode" ) );    
    textLabel5_3->setText( tr2i18n( "Hide automatically" ) );
    cbAutohide->setText( tr2i18n( "checkBox11" ) );
    tabPrefs->changeTab( TabPage_2, tr2i18n( "H&iding" ) );
    groupBox5->setTitle( tr2i18n( "Borders" ) );
    textLabel4_2->setText( tr2i18n( "Borders color" ) );
    btnBorderColor->setText( QString::null );
    cbBorders->setText( tr2i18n( "checkBox8" ) );
    textLabel3_2->setText( tr2i18n( "Show borders" ) );
    groupBox6->setTitle( tr2i18n( "Colors" ) );
    textLabel5_2->setText( tr2i18n( "Background color" ) );
    btnBgColor->setText( QString::null );
    btnSepColor->setText( QString::null );
    btnActiveDeskColor->setText( QString::null );
    btnInactiveDeskColor->setText( QString::null );
    textLabel6_2->setText( tr2i18n( "Separator color" ) );
    textLabel7_2_2->setText( tr2i18n( "Inactive desktop color" ) );
    textLabel7_2->setText( tr2i18n( "Active desktop color" ) );
    tabPrefs->changeTab( TabPage_3, tr2i18n( "&Appearance" ) );
    groupBox10->setTitle( tr2i18n( "Opacity" ) );
    textLabel10->setText( tr2i18n( "Dock Opacity" ) );
    //groupBox9->setTitle( tr2i18n( "Two-screen support" ) );
    //textLabel11->setText( tr2i18n( "Left monitor's screen width" ) );
    //cbXinerama->setText( tr2i18n( "checkBox8" ) );
    //textLabel1->setText( tr2i18n( "Enable two-screen support" ) );
    tabPrefs->changeTab( TabPage_4, tr2i18n( "&Misc" ) );
    grbTooltips->setTitle( tr2i18n( "Tooltips font" ) );
    groupBox13->setTitle( tr2i18n( "Colors" ) );
    textLabel3_3->setText( tr2i18n( "Background color" ) );
    textLabel2->setText( tr2i18n( "Text color" ) );
    ttColor->setText( QString::null );
    ttBgColor->setText( QString::null );
    textLabel1_4->setText( tr2i18n( "Show tooltips" ) );
    cbTooltips->setText( tr2i18n( "checkBox14" ) );
    tabPrefs->changeTab( TabPage_5, tr2i18n( "&Tooltips" ) );
    buttonGroup3->setTitle( tr2i18n( "Clock style" ) );
    rb24->setText( tr2i18n( "radioButton5" ) );
    rb12->setText( tr2i18n( "radioButton6" ) );
    textLabel5->setText( tr2i18n( "12 hours clock (AM, PM)" ) );
    textLabel4_3->setText( tr2i18n( "24 hours clock" ) );
    groupBox14->setTitle( tr2i18n( "Clock font" ) );
    textLabel2_4->setText( tr2i18n( "Text color" ) );
    btnClockTextColor->setText( QString::null );
    tabPrefs->changeTab( TabPage_6, tr2i18n( "&Clock" ) );
}

void ConfigDialog::cbTaskbar_stateChanged( int )
{
    cbShowWinAllDesks->setEnabled(cbTaskbar->isChecked());
}


void ConfigDialog::buttonQuit_clicked()
{
    hide();
}

void ConfigDialog::cbBorders_stateChanged( int )
{
    btnBorderColor->setEnabled(cbBorders->isChecked());
}

void ConfigDialog::cbXinerama_stateChanged( int ) {
    intScrWidth->setEnabled(cbXinerama->isChecked());
}

void ConfigDialog::cbTooltips_stateChanged( int ) {
	grbTooltips->setEnabled(cbTooltips->isChecked());
}

void ConfigDialog::rbParabolicZoom_stateChanged( int ) {
    grbParabolic->setEnabled(rbParabolicZoom->isChecked());
    grbNormal->setEnabled(!rbParabolicZoom->isChecked());
}

void ConfigDialog::buttonApply_clicked()
{
    int i = tabPrefs->currentPageIndex();

    switch (i)
    {
    case 0:
        applyComponents();
        break;
    case 1:
        applyZooming();
        break;
    case 2:
        applyArrangement();
        break;
    case 3:
        applyHiding();
        break;
    case 4:
        applyAppearance();
        break;
    case 5:
        applyMisc();
        break;
    case 6:
        applyTooltips();
        break;
    case 7:
        applyClock();
        break;
    default:
        break;
    }
}

void ConfigDialog::applyComponents() {
    m_parent->m_showPager = cbPager->isChecked();
    m_parent->m_showTaskbar = cbTaskbar->isChecked();
    m_parent->m_showWindowsAllDesktops = cbShowWinAllDesks->isChecked();
    m_parent->m_showClock = cbClock->isChecked();

    m_parent->loadLaunchers();
    m_parent->initPager();
    m_parent->loadTasks();
    m_parent->initClock();
    m_parent->updateLayout();

    m_parent->saveConfig();
}

void ConfigDialog::applyZooming() {
    if (getZoomMode() != m_parent->m_zoomMode) {
        m_parent->switchZoomMode();
    } else if (getZoomMode() == PARABOLIC_ZOOM && sldSpeedPZ->value() != m_parent->m_PzZoomSpeed) {
        m_parent->m_PzZoomSpeed = sldSpeedPZ->value();
    } else if (getZoomMode() == NORMAL_ZOOM && sldSpeedNZ->value() != m_parent->m_NzZoomSpeed) {
        m_parent->m_NzZoomSpeed = sldSpeedNZ->value();
    }
    m_parent->saveConfig();
}

void ConfigDialog::applyArrangement() {
    // bool updateDock = (m_parent->m_zoomMode == this->getZoomMode());
    if (m_parent->m_position != cbbPosition->currentItem()) {
        m_parent->m_position = static_cast<PanelPosition>(cbbPosition->currentItem());
        m_parent->m_orientation = (cbbPosition->currentItem() < 2) ? Qt::Horizontal : Qt::Vertical;
        m_parent->updateBackground();
    }

    m_parent->m_NzSmallIconSize = sldSmallIconNZ->value();
    m_parent->m_NzBigIconSize = sldBigIconNZ->value();
    if (cbbBaseIconSizeNZ->currentText().contains("64 x 64") >= 0)
        m_parent->m_NzBaseIconSize = 64;
    else
        m_parent->m_NzBaseIconSize = 128;

    m_parent->m_PzSmallIconSize = sldSmallIconPZ->value();
    m_parent->m_PzBigIconSize = sldBigIconPZ->value();
    if (cbbBaseIconSizePZ->currentText().contains("64 x 64") >= 0)
        m_parent->m_PzBaseIconSize = 64;
    else
        m_parent->m_PzBaseIconSize = 128;

    if (m_parent->m_zoomMode == NORMAL_ZOOM) {
        m_parent->m_baseIconSize = m_parent->m_NzBaseIconSize;
        m_parent->m_smallIconSize = m_parent->m_NzSmallIconSize;
        m_parent->m_bigIconSize = m_parent->m_NzBigIconSize;
    } else {
        m_parent->m_baseIconSize = m_parent->m_PzBaseIconSize;
        m_parent->m_smallIconSize = m_parent->m_PzSmallIconSize;
        m_parent->m_bigIconSize = m_parent->m_PzBigIconSize;
    }
    m_parent->loadLaunchers();
    m_parent->initPager();
    m_parent->loadTasks();
    m_parent->initClock();
    m_parent->updateLayout();
    m_parent->repaint();

    m_parent->saveConfig();
}

void ConfigDialog::applyHiding() {
	if (cbAutohide->isChecked() ^ m_parent->m_isAutohide)
	   m_parent->switchAutohideMode();
}

void ConfigDialog::applyAppearance() {
    m_parent->m_showBorders = cbBorders->isChecked();
    m_parent->m_borderColor = btnBorderColor->color();

    m_parent->m_backgroundColor = btnBgColor->color();
    m_parent->m_separatorColor = btnSepColor->color();
    m_parent->m_activeDesktopColor = btnActiveDeskColor->color();
    m_parent->m_inactiveDesktopColor = btnInactiveDeskColor->color();

    m_parent->updateBackground();
    m_parent->saveConfig();
}

void ConfigDialog::applyMisc() {
    if (m_parent->m_dockOpacity != sldOpacity->value()) {
        m_parent->m_dockOpacity = sldOpacity->value();
        m_parent->updateBackground();
    }

    /*
    if (cbXinerama->isChecked()) {
        if (m_parent->m_screenWidth != intScrWidth->value()) {
            m_parent->m_screenWidth = intScrWidth->value();
            //m_parent->updateScrWidth();
        }
    } else {
        if (m_parent->m_screenWidth != 0) {
            m_parent->m_screenWidth = 0;
            //m_parent->updateScrWidth();
        }
    }
    */

    m_parent->saveConfig();
}

void ConfigDialog::applyTooltips() {
    m_parent->m_showTooltip = cbTooltips->isChecked();
    m_parent->m_tooltipFontColor = ttColor->color();
    m_parent->m_tooltipBackgroundColor = ttBgColor->color();

    QFont font = ttFont->font();	
    m_parent->m_tooltipFontFace = font.family();
    m_parent->m_tooltipFontSize = font.pointSize();
    m_parent->m_tooltipFontIsBold = font.bold();
    m_parent->m_tooltipFontIsItalic = font.italic();

    m_parent->updateTooltip();
    m_parent->saveConfig();
}

void ConfigDialog::applyClock() {
    m_parent->m_use24HourClock = rb24->isChecked();
    m_parent->m_clockFontColor = btnClockTextColor->color();

    QFont font = fontClockText->font();
    m_parent->m_clockFontFace = font.family();
    m_parent->m_clockFontSize = font.pointSize();
    m_parent->m_clockFontIsBold = font.bold();
    m_parent->m_clockFontIsItalic = font.italic();
    m_parent->updateLayout();

    m_parent->updateClock();

    m_parent->saveConfig();
}

ZoomMode ConfigDialog::getZoomMode() {
    if (rbNormalZoom->isChecked())
        return NORMAL_ZOOM;
    else
        return PARABOLIC_ZOOM;
}

void ConfigDialog::sldOpacity_valueChanged( int )
{
    edtOpacity->setText(QString::number(sldOpacity->value()));
}


void ConfigDialog::sldSmallIconNZ_valueChanged( int )
{
    edtSmallIconNZ->setText(QString::number(sldSmallIconNZ->value()));
}


void ConfigDialog::sldBigIconNZ_valueChanged( int )
{
    edtBigIconNZ->setText(QString::number(sldBigIconNZ->value()));
}


void ConfigDialog::sldSmallIconPZ_valueChanged( int )
{
    edtSmallIconPZ->setText(QString::number(sldSmallIconPZ->value()));
}


void ConfigDialog::sldBigIconPZ_valueChanged( int )
{
    edtBigIconPZ->setText(QString::number(sldBigIconPZ->value()));
}

/**
 * Update configuration values from parent
 */

void ConfigDialog::updateValues() {
    rbNormalZoom->setChecked(m_parent->m_zoomMode == NORMAL_ZOOM);
    rbParabolicZoom->setChecked(m_parent->m_zoomMode == PARABOLIC_ZOOM);
    sldSpeedNZ->setValue(m_parent->m_NzZoomSpeed);
    sldSpeedPZ->setValue(m_parent->m_PzZoomSpeed);

    cbPager->setChecked(m_parent->m_showPager);
    cbTaskbar->setChecked(m_parent->m_showTaskbar);
    cbShowWinAllDesks->setChecked(m_parent->m_showWindowsAllDesktops);
    cbClock->setChecked(m_parent->m_showClock);

    cbbPosition->setCurrentItem(m_parent->getPosition());

    sldSmallIconNZ->setValue(m_parent->m_NzSmallIconSize);
    sldBigIconNZ->setValue(m_parent->m_NzBigIconSize);
    if (m_parent->m_NzBaseIconSize == 64)
        cbbBaseIconSizeNZ->setCurrentText("64 x 64");
    else
        cbbBaseIconSizeNZ->setCurrentText("128 x 128");

    sldSmallIconPZ->setValue(m_parent->m_PzSmallIconSize);
    sldBigIconPZ->setValue(m_parent->m_PzBigIconSize);
    if (m_parent->m_PzBaseIconSize == 64)
        cbbBaseIconSizePZ->setCurrentText("64 x 64");
    else
        cbbBaseIconSizePZ->setCurrentText("128 x 128");

    cbAutohide->setChecked(m_parent->m_isAutohide);

    cbBorders->setChecked(m_parent->m_showBorders);
    btnBorderColor->setColor(m_parent->m_borderColor);

    btnBgColor->setColor(m_parent->m_backgroundColor);
    btnSepColor->setColor(m_parent->m_separatorColor);
    btnActiveDeskColor->setColor(m_parent->m_activeDesktopColor);
    btnInactiveDeskColor->setColor(m_parent->m_inactiveDesktopColor);

    sldOpacity->setValue(m_parent->m_dockOpacity);
    cbXinerama->setChecked(m_parent->m_screenWidth != 0);
    intScrWidth->setValue(m_parent->m_screenWidth);

    cbTooltips->setChecked(m_parent->m_showTooltip);
    ttColor->setColor(m_parent->m_tooltipFontColor);
    ttBgColor->setColor(m_parent->m_tooltipBackgroundColor);

    QFont font = QFont(m_parent->m_tooltipFontFace, m_parent->m_tooltipFontSize);
    font.setBold(m_parent->m_tooltipFontIsBold);
    font.setItalic(m_parent->m_tooltipFontIsItalic);
    ttFont->setFont(font);

    rb24->setChecked(m_parent->m_use24HourClock);
    rb12->setChecked(!m_parent->m_use24HourClock);	
    
    btnClockTextColor->setColor(m_parent->m_clockFontColor);

    QFont font2 = QFont(m_parent->m_clockFontFace, m_parent->m_clockFontSize);
    font2.setBold(m_parent->m_clockFontIsBold);
    font2.setItalic(m_parent->m_clockFontIsItalic);
    fontClockText->setFont(font2);
}

/**
 * Set the current tab page
 */

void ConfigDialog::setCurrentPage(int pageIndex) {
    tabPrefs->setCurrentPage(pageIndex);
}

#include "configdialog.moc"
