/***************************************************************************
                          confdialog.h  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2003-2005 by KSmoothDock team
    email                : dangvd@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFDIALOG_H
#define CONFDIALOG_H

#include <qvariant.h>
#include <qdialog.h>

#include "constants.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPushButton;
class QTabWidget;
class QWidget;
class QGroupBox;
class QButtonGroup;
class QLabel;
class QRadioButton;
class QCheckBox;
class QLineEdit;
class QSlider;
class QComboBox;
class KColorButton;
class KIntNumInput;
class KFontChooser;

class KSmoothDock;

class ConfigDialog : public QDialog
{
    Q_OBJECT

public:
    ConfigDialog( KSmoothDock* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~ConfigDialog();

    /// Update configuration values from parent
    void updateValues();

    /// Set the current tab page
    void setCurrentPage(int pageIndex);

public slots:
    virtual void cbTaskbar_stateChanged( int );
    virtual void buttonQuit_clicked();
    virtual void cbBorders_stateChanged( int );
    virtual void buttonApply_clicked();
    virtual void sldOpacity_valueChanged( int );
    virtual void sldSmallIconNZ_valueChanged( int );
    virtual void sldBigIconNZ_valueChanged( int );
    virtual void sldSmallIconPZ_valueChanged( int );
    virtual void sldBigIconPZ_valueChanged( int );
    virtual void cbTooltips_stateChanged( int );
    virtual void cbXinerama_stateChanged(int);
    virtual void rbParabolicZoom_stateChanged( int );

protected slots:
    virtual void languageChange();
    
private:
    QPushButton* buttonApply;
    QPushButton* buttonQuit;
    QTabWidget* tabPrefs;
    QWidget* Widget2;
    QGroupBox* groupBox2;
    QLabel* textLabel1_3;
    QLabel* textLabel6;
    QCheckBox* cbPager;
    QCheckBox* cbTaskbar;
    QCheckBox* cbClock;
    QCheckBox* cbShowWinAllDesks;
    QCheckBox* cbQuickLaunch;
    QLabel* textLabel7;
    QLabel* textLabel2_3;
    QLabel* textLabel9;
    QWidget* Widget3;
    QGroupBox* grbParabolic;
    QLabel* textLabel1_6_2;
    QLabel* textLabel2_5_2;
    QLabel* textLabel3_4_2;
    QSlider* sldSpeedPZ;
    QGroupBox* grbNormal;
    QLabel* textLabel1_6;
    QLabel* textLabel2_5;
    QLabel* textLabel3_4;
    QSlider* sldSpeedNZ;
    QGroupBox* groupBox1;
    QButtonGroup* buttonGroup2;
    QLabel* textLabel3;
    QLabel* textLabel4;
    QRadioButton* rbNormalZoom;
    QRadioButton* rbParabolicZoom;
    QLabel* textLabel1_2;
    QWidget* TabPage;
    QGroupBox* gbPosition;
    QLabel* lbPosition;
    QComboBox* cbbPosition;
    QGroupBox* groupBox15;
    QGroupBox* groupBox3;
    QSlider* sldSmallIconNZ;
    QLabel* textLabel2_2;
    QSlider* sldBigIconNZ;
    QLineEdit* edtSmallIconNZ;
    QLabel* textLabel2_2_2;
    QLabel* textLabel8;
    QComboBox* cbbBaseIconSizeNZ;
    QLineEdit* edtBigIconNZ;
    QGroupBox* groupBox4;
    QSlider* sldSmallIconPZ;
    QLabel* textLabel2_2_3;
    QSlider* sldBigIconPZ;
    QLineEdit* edtSmallIconPZ;
    QLabel* textLabel2_2_2_2;
    QLabel* textLabel8_2;
    QComboBox* cbbBaseIconSizePZ;
    QLineEdit* edtBigIconPZ;    
    QWidget* TabPage_2;
    QGroupBox* groupBox17;
    QLabel* textLabel5_3;
    QCheckBox* cbAutohide;
    QLabel* textLabel6_3;    
    QLabel* textLabel7_3;
    QLabel* textLabel1_6_3;    
    QLabel* textLabel2_5_3;
    QLabel* textLabel3_4_3;    
    QWidget* TabPage_3;
    QGroupBox* groupBox5;
    QLabel* textLabel4_2;
    KColorButton* btnBorderColor;
    QCheckBox* cbBorders;
    QLabel* textLabel3_2;
    QGroupBox* groupBox6;
    QLabel* textLabel5_2;
    KColorButton* btnBgColor;
    KColorButton* btnSepColor;
    KColorButton* btnActiveDeskColor;
    KColorButton* btnInactiveDeskColor;
    QLabel* textLabel6_2;
    QLabel* textLabel7_2_2;
    QLabel* textLabel7_2;
    QWidget* TabPage_4;
    QGroupBox* groupBox10;
    QLabel* textLabel10;
    QLineEdit* edtOpacity;
    QSlider* sldOpacity;
    QGroupBox* groupBox9;
    QLabel* textLabel11;
    KIntNumInput* intScrWidth;
    QCheckBox* cbXinerama;
    QLabel* textLabel1;
    QWidget* TabPage_5;
    QGroupBox* grbTooltips;
    QGroupBox* groupBox13;
    QLabel* textLabel3_3;
    QLabel* textLabel2;
    KColorButton* ttColor;
    KColorButton* ttBgColor;
    KFontChooser* ttFont;
    QLabel* textLabel1_4;
    QCheckBox* cbTooltips;
    QWidget* TabPage_6;
    QButtonGroup* buttonGroup3;
    QRadioButton* rb24;
    QRadioButton* rb12;
    QLabel* textLabel5;
    QLabel* textLabel4_3;
    QGroupBox* groupBox14;
    QLabel* textLabel2_4;
    KColorButton* btnClockTextColor;
    KFontChooser* fontClockText;
    
private:  
    void applyComponents();
    void applyZooming();
    void applyArrangement();
    void applyHiding();
    void applyAppearance();
    void applyMisc();
    void applyTooltips();
    void applyClock();
    ZoomMode getZoomMode();

private:
    KSmoothDock *m_parent;

};

#endif // CONFDIALOG_H
