/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "desktopselector.h"

#include <qcursor.h>
#include <qpainter.h>

#include <klocale.h>
#include <kprocess.h>
#include <kwin.h>

#include "ksmoothdock.h"

DesktopSelector::DesktopSelector() {}

DesktopSelector::DesktopSelector(KSmoothDock* parent, int itemId, QString desc, int desktop, QPixmap& icon, int minSize, int maxSize, Qt::Orientation orientation, int targetDesktop, WallpaperManager* wallpaperManager)
 : IconBasedDockItem(parent, itemId, desc, desktop, icon, minSize, maxSize, orientation), m_targetDesktop(targetDesktop), m_wallpaperManager(wallpaperManager)
{
}

/** 
 * Draw itself into the offscreen buffer
 * @param buffer the offscreen buffer
 * @param x x-coordinate to start drawing
 * @param y y-coordinate to start drawing
 * @param size size of the dock item icon (width or height depending on the orientation)
 */

void DesktopSelector::draw(QPixmap& buffer, int x, int y, int size) {
    if (size >= m_minSize && size <= m_maxSize) {
        bitBlt(&buffer, x, y, &m_icons.at(size - m_minSize));

        QPainter p(&buffer);
        if (KWin::currentDesktop() == m_targetDesktop)
            p.setPen(m_parent->getActiveDesktopColor());
        else
            p.setPen(m_parent->getInactiveDesktopColor());

        int w = 0;
        int h = 0;

        if (m_orientation == Qt::Horizontal) {
            h = size;
            w = h * getMaxWidth() / getMaxHeight() + 1;
        } else {
            w = size;
            h = w * getMaxHeight() / getMaxWidth() + 1;
        }

        QRect r(x, y, w, h);
        p.drawRect(r);
        p.setPen(Qt::white);
        QFont font(m_parent->getClockFontFace(), h/2);
        p.setFont(font);
        p.drawText(r, AlignCenter, QString::number(m_targetDesktop));
    }
}

/** 
 * Mouse pressed event handler
 */

void DesktopSelector::mousePressEvent(QMouseEvent* e) {
    if (e->button() == Qt::LeftButton) { // if left-click, switch desktop if it is not the current desktop
        if (KWin::currentDesktop() != m_targetDesktop) {
            KWin::setCurrentDesktop(m_targetDesktop);
        }
    } else { // if right-click, display the task's popup menu
        KPopupMenu popup(m_parent);
        popup.insertItem(i18n("Configure Desktop &Wallpaper"), this, SLOT(configureWallpaper()));
        popup.insertItem(i18n("Configure Desktop &Screen Saver"), this, SLOT(configureScreenSaver()));
        popup.exec(QCursor::pos());    
    }
}

/**
 * Update the icon when wallpaper has changed
 */

void DesktopSelector::updateIcon() {
    if (KWin::currentDesktop() == m_targetDesktop) { // if the target desktop wallpaper is the current desktop, load new wallpaper
        setIcon(m_wallpaperManager->getWallpaper(m_targetDesktop));
    }
}

/**
 * Configure desktop wallpaper
 */

void DesktopSelector::configureWallpaper() {
    KProcess proc;
    proc << "kcmshell" << "background";
    proc.start(KProcess::DontCare);
}

/**
 * Configure desktop screen saver
 */

void DesktopSelector::configureScreenSaver() {
    KProcess proc;
    proc << "kcmshell" << "screensaver";
    proc.start(KProcess::DontCare);
}

