/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DESKTOPSELECTOR_H
#define DESKTOPSELECTOR_H

#include "iconbaseddockitem.h"

/**
 * @short Class represents a desktop chooser dock item
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <qcolor.h>
#include <qobject.h>

#include "wallpapermanager.h"

class DesktopSelector : public QObject, public IconBasedDockItem
{
    Q_OBJECT
public:
    DesktopSelector();

    DesktopSelector(KSmoothDock* parent, int itemId, QString desc, int desktop, QPixmap& icon, int minSize, int maxSize, Qt::Orientation orientation, int targetDesktop, WallpaperManager* wallpaperManager);

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

public slots:
    /// Update the icon when wallpaper has changed
    void updateIcon();

    /// Configure desktop wallpaper
    void configureWallpaper();

    /// Configure desktop screen saver
    void configureScreenSaver();

private:
    int m_targetDesktop;
    WallpaperManager* m_wallpaperManager;
};

#endif
