/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ICONBASEDDOCKITEM_H
#define ICONBASEDDOCKITEM_H

#include "dockitem.h"

/**
 * @short Base class for icon-based dock items
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <vector>

#include <qpixmap.h>
#include <qstring.h>

class IconBasedDockItem : public DockItem {
public:
    /// Constructors
    IconBasedDockItem();
    IconBasedDockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, QPixmap& icon, int minSize, int maxSize, Qt::Orientation orientation);
    IconBasedDockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, QString iconName, int baseSize, int minSize, int maxSize, Qt::Orientation orientation);
    IconBasedDockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, double whRatio, int minSize, int maxSize, Qt::Orientation orientation);

    /// Get the icon with a specific size
    QPixmap& getIcon(int size);

    /// Set the base icon
    void setIcon(QPixmap& icon);

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size);

    /// Get max width
    virtual int getMaxWidth();
    
    /// Get max height
    virtual int getMaxHeight();

    /// Get min width
    virtual int getMinWidth();
    
    /// Get min height
    virtual int getMinHeight();

    /// Get width for a specific size
    virtual int getWidth(int size);
    
    /// Get height for a specific size
    virtual int getHeight(int size);

private: // functions
    // Generate icons with different sizes
    void generateIcons(QPixmap& icon);

protected: // data
    int m_minSize; // the minimum size of the item's icon
    int m_maxSize; // the maximum size of the items's icon
    std::vector<QPixmap> m_icons; // vector contains different sizes of the item's icon
};

#endif
