/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAUNCHER_H
#define LAUNCHER_H

#include "iconbaseddockitem.h"

/**
 * @short Class represents a quick launcher dock item
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

class Launcher : public IconBasedDockItem
{
public:
    // Constructors
    Launcher();
    Launcher(QString desc, QString iconName, QString command);
    Launcher(QString fileName);
    Launcher(KSmoothDock* parent, int itemId, QString desc, int desktop, QString iconName, int baseSize, int minSize, int maxSize, Qt::Orientation orientation, QString command);
    Launcher(KSmoothDock* parent, int itemId, QString fileName, int baseSize, int minSize, int maxSize, Qt::Orientation orientation);

    /// Get the command
    QString getCommand();

    /// Get the icon name
    QString getIconName();

    /// Set new command
    void setCommand(QString command);

    /// Set new icon
    void setIconName(QString iconName);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);

    /// Draw itself into the offscreen buffer with mouse clicked acknowledgement
    void drawAcknowledgement(QPixmap& buffer, int x, int y, int size);

    /// Save the launcher info into a Link-to-Application file
    void saveToFile(QString fileName);
private:
    QString m_command; // the command associated with this quick launcher
    QString m_iconName; // the icon name
};

#endif
