/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "task.h"

#include <qcursor.h>

#include <klocale.h>
#include <kpopupmenu.h>
#include <kwin.h>
#include <netwm.h>

#include "ksmoothdock.h"

Task::Task() {}

Task::Task(KSmoothDock* parent, int itemId, QString desc, int desktop, QPixmap& icon, int minSize, int maxSize, Qt::Orientation orientation, int winId)
 : IconBasedDockItem(parent, itemId, desc, desktop, icon, minSize, maxSize, orientation), m_winId(winId), m_demandsAttention(false), m_timer(NULL), m_timerCount(0)
{
}

/** 
 * Draw itself into the offscreen buffer
 * @param buffer the offscreen buffer
 * @param x x-coordinate to start drawing
 * @param y y-coordinate to start drawing
 * @param size size of the dock item icon (width or height depending on the orientation)
 */

void Task::draw(QPixmap& buffer, int x, int y, int size) {
    if (size >= m_minSize && size <= m_maxSize) {
        if (m_demandsAttention && (m_timerCount == 1)) {
            KPixmap pix(m_icons.at(size - m_minSize));
            KPixmapEffect::fade(pix, 0.5, QColor("#ffffff"));
            bitBlt(&buffer, x, y, &pix);            
        } else {
            bitBlt(&buffer, x, y, &m_icons.at(size - m_minSize));
        }
    }
}

/** 
 * Mouse pressed event handler
 */

void Task::mousePressEvent(QMouseEvent* e) {
    if (e->button() == Qt::LeftButton) { // if left-click, set focus on the task
        KWin::forceActiveWindow(m_winId);
    } else { // if right-click, display the task's popup menu
    	KPopupMenu popup(m_parent);
    	popup.insertItem(i18n("&Close Task"), this, SLOT(closeTask()));
        popup.exec(QCursor::pos());    
    }
}

/** 
 * Return window id
 */

WId Task::getWinId() {
    return m_winId;
}

/**
 * Get demands attention
 */

bool Task::getDemandsAttention() {
    return m_demandsAttention;
}

/**
 * Set demands attention
 */

void Task::setDemandsAttention(bool value) {
    m_demandsAttention = value;
    if (m_demandsAttention) {
        if (m_timer == NULL) {
            m_timer = new QTimer(this);
            connect(m_timer, SIGNAL(timeout()), this, SLOT(timerTicked()));
        }    
        m_timer->start(500);
        m_timerCount = 0;
    } else {
        m_timer->stop();
        m_parent->updateItem(m_itemId);
    }
}

void Task::minTask() {
    KWin::iconifyWindow(m_winId);
}

void Task::maxTask() {
    KWin::setState(m_winId, NET::MaxVert + NET::MaxHoriz);
}

void Task::closeTask() {
    NETRootInfo root(qt_xdisplay(), NET::CloseWindow);
    root.closeWindowRequest(m_winId);
}

/**
 * The internal timer ticked
 */

void Task::timerTicked() {
    m_timerCount = 1 - m_timerCount; // m_timerCount has 2 values only: 0 and 1
    m_parent->updateItem(m_itemId);
}

#include "task.moc"
