
/*
 * LaTeX Symbols Selector
 *
 * Copyright (C) 2006 Tomasz Mąka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <gtk/gtk.h>

#include "gui.h"
#include "send.h"


gboolean
send_symbol_to_gvim (gchar *symbol) {

FILE *handle;
gchar server_name[BUFFER_SIZE], cmd[BUFFER_SIZE];
gint i, flag, len;

    handle = popen(GVIM_SERVERS_LIST_CMD, "r");

    if (!handle)
        return FALSE;

    flag = 0;

    len = fread (server_name, 1, BUFFER_SIZE, handle);

    if (!len)
        return FALSE;

    for(i=0; i < BUFFER_SIZE; i++)
        if(server_name[i] == '\n') {
            server_name[i]='\0';
            flag = 1;
            break;
        }

    if(!WIFEXITED(pclose(handle)))
        return FALSE;

    if (flag) {
        snprintf(cmd, BUFFER_SIZE, GVIM_SERVER_SEND_TEXT_CMD, server_name, symbol);
        system(cmd);
    }

    return TRUE;
}



gboolean
send_symbol_to_clipboard (gchar *symbol) {

GdkAtom clip_atom;

    clip_atom = gdk_atom_intern ("CLIPBOARD", FALSE);
    gtk_clipboard_set_text(gtk_clipboard_get(clip_atom),
                           symbol, -1);

    clip_atom = gdk_atom_intern ("PRIMARY", FALSE);
    gtk_clipboard_set_text(gtk_clipboard_get(clip_atom),
                           symbol, -1);

    return TRUE;
}


