/**
 * $Id: inflate.c,v 1.8 2006/04/22 18:46:22 shinh Exp $
 *
 * Copyright (C) shinichiro.h <hamaji@nii.ac.jp>
 *  http://shinh.skr.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
 * The present copyright holders of this program have given permission,
 * as a special exception, to link this program with Apache Portable
 * Runtime (APR) and to include header files for APR components when
 * those header files are covered by the Apache licenses, as long as
 * the GNU GPL is followed for this program in all other ways. 
 */

#include <zlib.h>

#include <stdio.h>
#include <stdlib.h>

static const int ASCII_FLAG = 0x01; /* bit 0 set: file probably ascii text */
static const int HEAD_CRC = 0x02; /* bit 1 set: header CRC present */
static const int EXTRA_FIELD = 0x04; /* bit 2 set: extra field present */
static const int ORIG_NAME = 0x08; /* bit 3 set: original file name present */
static const int COMMENT = 0x10; /* bit 4 set: file comment present */
static const int RESERVED = 0xE0; /* bits 5..7: reserved */

static int checkHeader(Bytef* buf) {
  int i = 2;
  int method = buf[i++];
  int flags  = buf[i++];

  if (method != Z_DEFLATED || (flags & RESERVED) != 0) {
    return -1;
  }

  i+=6;

  if (flags & EXTRA_FIELD) { /* skip the extra field */
    int len = 0;
    len  =  (uInt)buf[i++];
    len += ((uInt)buf[i++])<<8;
    /* len is garbage if EOF but the loop below will quit anyway */
    i+=len;
  }
  if (flags & ORIG_NAME) { /* skip the original file name */
    while (buf[i++] !=0) {}
  }
  if (flags & COMMENT) {   /* skip the .gz file comment */
    while (buf[i++] != 0) {}
  }
  if (flags & HEAD_CRC) {  /* skip the header crc */
    i += 2;
  }
  return i;
}

char *estraier_uncompress(char* gis_c, int gis_length, int* gos_length,
                          int limit) {
  static const int BUFSIZE = 4 * 1024;
  Bytef *gis = (Bytef *)gis_c;
  Bytef *gos;
  Bytef *p;
  int allLen = 0;

  int h = checkHeader(gis);

  if (h == -1) return NULL;

  z_stream z;

  gis += h;

  z.zalloc = (alloc_func)Z_NULL;
  z.zfree = (free_func)Z_NULL;
  z.opaque = (void *)Z_NULL;

  int status = inflateInit2(&z, -15);
  if (status != Z_OK) {
    return NULL;
  }

  z.next_in = gis;
  z.avail_in = gis_length;

  z.next_out = p = gos = (Bytef *)malloc(BUFSIZE);
  z.avail_out = BUFSIZE;

  status = Z_OK;
  while (status != Z_STREAM_END) {
    if (z.avail_in == 0) {
      break;
    }

    status = inflate(&z, Z_NO_FLUSH);
    if (status == Z_STREAM_END) {
      int used = BUFSIZE - z.avail_out;
      allLen += used;
      break;
    }
    if (status != Z_OK) {
      free(gos);
      printf("err: %s %d\n", z.msg, status);
      return NULL;
    }
    if (z.avail_out == 0) {
      allLen += BUFSIZE;
      gos = (Bytef *)realloc(gos, allLen + BUFSIZE + 1);
      p = gos + allLen;

      if (allLen > limit) return NULL;

      z.next_out = p;
      z.avail_out = BUFSIZE;
    }
  }

  *gos_length = allLen;
  gos[*gos_length] = '\0';

  return (char *)gos;
}

