/*
** PHREL
** $Id: trap.h,v 1.4 2006/04/06 00:38:08 sella Exp $
** Copyright (c) 2005,2006 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_TRAP_H
#define __DGS_TRAP_H

#include "config.h"

#include "phrel.h"

#include <snmptrap.h>

#define TRAP_PROCESS_STARTUP ".1.3.6.1.4.1.25439.1.2.3.1" /* phrelTrap.processStartup */
#define TRAP_PROCESS_SHUTDOWN ".1.3.6.1.4.1.25439.1.2.3.2" /* phrelTrap.processShutdown */
#define TRAP_PROCESS_RESTART ".1.3.6.1.4.1.25439.1.2.3.3" /* phrelTrap.processRestart */
#define TRAP_SYNC_LOST ".1.3.6.1.4.1.25439.1.2.3.4" /* phrelTrap.syncLost */
#define TRAP_THRESHOLD_INCREASE ".1.3.6.1.4.1.25439.1.2.3.5" /* phrelTrap.thresholdIncrease */
#define TRAP_THRESHOLD_DECREASE ".1.3.6.1.4.1.25439.1.2.3.6" /* phrelTrap.thresholdDecrease */

#define OID_ID ".1.3.6.1.4.1.25439.1.2.1.1" /* phrelMIB.phrelCMI.phrelID */
#define OID_HOST ".1.3.6.1.4.1.25439.1.2.1.2" /* phrelMIB.phrelCMI.phrelHost */
#define OID_PPS ".1.3.6.1.4.1.25439.1.2.1.3" /* phrelMIB.phrelCMI.phrelPPS */
#define OID_THRES ".1.3.6.1.4.1.25439.1.2.1.4" /* phrelMIB.phrelCMI.phrelThreshold */
#define OID_LTHRES ".1.3.6.1.4.1.25439.1.2.1.5" /* phrelMIB.phrelCMI.phrelThresholdLast */
#define OID_RATE ".1.3.6.1.4.1.25439.1.2.1.6" /* phrelMIB.phrelCMI.phrelRate */
#define OID_BURST ".1.3.6.1.4.1.25439.1.2.1.7" /* phrelMIB.phrelCMI.phrelBurst */
#define OID_DECAY ".1.3.6.1.4.1.25439.1.2.1.8" /* phrelMIB.phrelCMI.phrelDecay */

/* Function definitions. */
int snmptrap_process_startup();
int snmptrap_process_shutdown();
int snmptrap_process_restart();
int snmptrap_sync_lost();
int snmptrap_threshold_increase(struct data_t* data, unsigned int pps, unsigned int prev_threshold);
int snmptrap_threshold_decrease(struct data_t* data, unsigned int pps, unsigned int prev_threshold);

int init_snmptrap_t(const char *trap_oid, snmptrap_t *trap);
int snmptrap_pid(const char *trap_oid);
int snmptrap_threshold(const char* trap_oid, struct data_t* data, unsigned int pps, unsigned int threshold_last);

#endif

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
