/*****************************************************************************
 * input-jni.cc: JNI native input functions for VLC Java Bindings
 *****************************************************************************
 * Copyright (C) 1998-2006 the VideoLAN team
 *
 * Authors: Filippo Carone <filippo@carone.org>
 *
 *
 * $Id $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************/

#include <jni.h>

#include <vlc/libvlc.h>

/* JVLC internal imports, generated by gcjh */
#include "../includes/Input.h"
#include "utils.h"

JNIEXPORT jlong JNICALL Java_org_videolan_jvlc_Input__1getLength (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION ;
    vlc_int64_t res = 0;

    GET_INPUT_THREAD ;

    res = libvlc_input_get_length( input, exception );
    CHECK_EXCEPTION_FREE;

    return res;
}

JNIEXPORT jfloat JNICALL Java_org_videolan_jvlc_Input__1getPosition (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION;
    jfloat res;
    
    GET_INPUT_THREAD ;

    res = libvlc_input_get_position( input, exception );
    CHECK_EXCEPTION_FREE;

    return res;
}

JNIEXPORT jlong JNICALL Java_org_videolan_jvlc_Input__1getTime (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION;
    vlc_int64_t res = 0;

    GET_INPUT_THREAD ;

    res = libvlc_input_get_time( input, exception );
    CHECK_EXCEPTION_FREE ;

    return res;
}

JNIEXPORT jfloat JNICALL Java_org_videolan_jvlc_Input__1getFPS (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION;
    float res;

    GET_INPUT_THREAD ;

    res = libvlc_input_get_fps( input, exception );
    CHECK_EXCEPTION_FREE ;

    return res;
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_Input__1setTime (JNIEnv *env, jobject _this, jlong time) 
{
    INIT_FUNCTION;

    GET_INPUT_THREAD ;

    libvlc_input_set_time( input, time, exception );
    CHECK_EXCEPTION_FREE;
        
}

JNIEXPORT void JNICALL Java_org_videolan_jvlc_Input__1setPosition (JNIEnv *env, jobject _this, jfloat position )
{
    INIT_FUNCTION;

    GET_INPUT_THREAD ;

    libvlc_input_set_position( input, position, exception );
    CHECK_EXCEPTION_FREE;
}

JNIEXPORT jboolean JNICALL Java_org_videolan_jvlc_Input__1isPlaying (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION ;
    vlc_bool_t res = 0;
    
    GET_INPUT_THREAD ;
    
    res = libvlc_input_will_play( input, exception );
    CHECK_EXCEPTION_FREE ;
    
    return res;
}

JNIEXPORT jboolean JNICALL Java_org_videolan_jvlc_Input__1hasVout (JNIEnv *env, jobject _this) 
{
    INIT_FUNCTION ;
    vlc_bool_t res = 0;
    
    GET_INPUT_THREAD ;
    
    res = libvlc_input_has_vout( input, exception );
    CHECK_EXCEPTION_FREE ;
    
    return res;
}

